#
# $Id$
#
Summary:	Busybox version suited for Mindi
Name:		mindi-busybox
Version:	1.21.1
Release:	1.centos5
License:	GPLv2
Group:		Applications/Archiving
Url:		http://www.mondorescue.org
Source:		ftp://ftp.mondorescue.org//src/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(id -u -n)
BuildRequires:	gcc-c++
# Cf: https://bugzilla.redhat.com/show_bug.cgi?id=588550
ExcludeArch:	ppc

%description
This package provides a busybox version suited for Mindi.
Mindi is a script to create boot/root disks based on your system. 
It uses Busybox during the restore process to provide a small Unix environement.
This package prepares busybox the right way for mindi.
Homepage: http://www.mondorescue.org

%prep
%setup -q

%build
make oldconfig
make busybox

%install
rm  -rf $RPM_BUILD_ROOT

export DESTDIR=${RPM_BUILD_ROOT}%{_libdir}/mindi/rootfs
make CONFIG_PREFIX=$DESTDIR install
# Make it compatible with latest crazy /bin removal 
./mondo-install.sh

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc ChangeLog LICENSE AUTHORS README TODO NEWS 
#svn.log
%{_libdir}/mindi/rootfs

%changelog
* Fri Jun 27 2014 Bruno Cornec <bruno@mondorescue.org> 1.21.1-1
- Updated to 1.21.1-1
- Update to upstream 1.21.1 (Bruno Cornec)
- Force generation of hardlinks to avoid package build problem on some distro with inexistant links at build time like recent SLES (Bruno Cornec)
- Fix busybox 1.21.1 to support back old distributions such as RHEL3 and RHEL4 or SLES9 by avoiding usage of the struct tpacket_auxdata (proposed upstream but not accepted (Bruno Cornec)
- Adds a post install script for mindi-busybox placing everything under /usr (Bruno Cornec)

* Fri Mar 15 2013 Bruno Cornec <bruno@mondorescue.org> 1.18.5-3
- Updated to 1.18.5-3
- Try to improve ctrl-alt-del detection by adding busybox options (including syslog, klog which were missing). showkey show that the sendkey from KVM generates the right keycodes however the system still doesn't reboot. This is then still a limitation as per #627 (Bruno Cornec)
- mindi-busybox now uses an inittab which should help fixing #627 (Bruno Cornec)
- Patches to render this mindi-busybox version compatible with RHEL3 at least, potentially all older Linux 2.4 based distros (Bruno Cornec)
- Fix #632 by adding a required include to build mindi-busybox on Arch Linux (Stefan Husmann/MC)

* Fri Jan 27 2012 Bruno Cornec <bruno@mondorescue.org> 1.18.5-2
- Updated to 1.18.5-2
- Adds a Replace in .deb packages to handle correctly the update process (Bruno Cornec)

* Fri Dec 23 2011 Bruno Cornec <bruno@mondorescue.org> 1.18.5-1
- Updated to 1.18.5-1
- Adds support for SUID binaries (Bruno Cornec)
- Fix #499 for good, by using a real init from busybox and moving our init script to etc/init.d/rcS. We also now call the reboot from busybox to exit, which indeed reset the system correctly (in a VM at least which wasn't the case before). Requires a new mindi-busybox as well. (Bruno Cornec)
- Fixes the shell msg error by using setsid as per Busybox FAQ (Bruno Cornec)
- Update to upstream busybox 1.18.5 (Bruno Cornec)

* Mon Jun 27 2011 Bruno Cornec <bruno@mondorescue.org> 1.18.3-3
- Updated to 1.18.3-3
- Adds the swapon feature to mindi-busybox (Bruno Cornec)
- Removes telinit call in busybox to try to fix problems when reboot at end of restore (Bruno Cornec)
- Addes an extraversion for revision support (Bruno Cornec)
- Adds support for ifconfig and ping for PXE+NFS boot for this version of mindi-busybox (Bruno Cornec)
- Adds support for MT back mandatory for OBDR (Bruno Cornec)

* Tue Apr 12 2011 Bruno Cornec <bruno@mondorescue.org> 1.18.3-2
- Updated to 1.18.3-2
- Remove blkid from busybox to solve #435 (Bruno Cornec)

* Sun Feb 27 2011 Bruno Cornec <bruno@mondorescue.org> 1.18.3-1
- Updated to 1.18.3-1
- Updated based on busybox 1.18.3 to solve tar issues with latest RHEL 6 e.g. (Bruno Cornec)

* Sat Mar 22 2008 Bruno Cornec <bruno@mondorescue.org> 1.7.3-1
- Updated to 1.7.3-1
- Updated based on busybox 1.7.3 (Bruno Cornec)
- Fix gentoo installation issue (Francesco Talamona/Bruno Cornec)
- remove MONOTONIC clock to continue to support 2.4 kernels (RHEL 3 e.g. or ESX) (Bruno Cornec)
- Adds dd support for swap partition label (Bruno Cornec)
- Try to add cttyhack to suppress an error message at shell level (Bruno Cornec)

* Tue Oct 30 2007 Bruno Cornec <bruno@mondorescue.org> 1.7.2-1
- Updated to 1.7.2-1
- Updated based on busybox 1.7.2 (Bruno Cornec)

* Thu Oct 11 2007 Bruno Cornec <bruno@mondorescue.org> 1.2.2-4
- Updated to 1.2.2-4
- Build process adapted to use pb (http://trac.project-builder.org) (Bruno Cornec)
- Fix another issue in mindi-busybox gentoo's ebuild (Francesco Talamona)

* Thu May 17 2007 Bruno Cornec <bruno@mondorescue.org> 1.2.2-3
- Updated to 1.2.2-3
- Fix a blocking bug in mindi-busybox gentoo's ebuild (Francesco Talamona)

* Sun Apr 08 2007 Bruno Cornec <bruno@mondorescue.org> 1.2.2-2
- Updated to 1.2.2-2
- Improve Gentoo packaging (Linos)

* Sat Dec 23 2006 Bruno Cornec <bruno@mondorescue.org> 1.2.2-1
- Updated to 1.2.2
- mindi-busybox version is now extended with the SVN revision (Bruno Cornec)
- Fix a known bug for busybox where -gc-section in makefile + static for link crea tes a buggy busybox with glibc (Bruno Cornec)
- Updated based on busybox 1.2.2 (Bruno Cornec)
- Handles modules back again (Bruno Cornec)
- Fix bug #88 around install conflicts (Bruno Cornec)

* Wed Oct 04 2006 Bruno Cornec <bruno@mondorescue.org> 1.2.1-1
- Updated to 1.2.1
- Creation based on busybox 1.2.1 (Bruno Cornec)
- Remove module management, bunzip2 in config file (Bruno Cornec)


