#
# $Id$
#
%define perlvendorlib %(eval "`%{__perl} -V:installvendorlib`"; echo $installvendorlib)
%define srcname project-builder

Summary:	Project Builder aka pb is a tool to produce packages for multiple distributions
Summary(fr):	Project Builder ou pb est un programme pour produire des paquets pour diverses distributions

Name:		project-builder
Version:	0.9.5
Release:	1.fc8
License:	GPL
Group:		Applications/Archiving
Url:		http://trac.project-builder.org
Source:		ftp://ftp.project-builder.org/src/%{srcname}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(id -u -n)
BuildArch:	noarch
Requires:	perl >= 5.8.4, perl-DateManip, perl-ProjectBuilder, rpm-build,  

%description
Project Builder aka pb helps producing packages
for multiple distributions. It does that by minimizing
the duplication of information required and
a set a very simple configuration files.

%description -l fr
Project Builder ou pb est un programme pour produire des paquets pour 
diverses distributions.
Il réalise cela en minimisant la duplication des informations requises 
et par un jeu de fichiers de configuration très simples.

%prep
%setup -q

%build
%{__perl} Makefile.PL INSTALLDIRS=vendor destdir=${RPM_BUILD_ROOT}/ 
make

%install
%{__rm} -rf $RPM_BUILD_ROOT
make DESTDIR=${RPM_BUILD_ROOT} install
find ${RPM_BUILD_ROOT} -type f -name perllocal.pod -o -name .packlist -o -name '*.bs' -a -size 0 | xargs rm -f
find ${RPM_BUILD_ROOT} -type d -depth | xargs rmdir --ignore-fail-on-non-empty

%check
make test

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc NEWS AUTHORS
%doc INSTALL COPYING README

%{perlvendorlib}/*
%{_bindir}/*
%{_mandir}/man1/*
%{_mandir}/man3/*

%changelog
* Tue Dec 09 2008 Bruno Cornec <bruno@project-builder.org> 0.9.5-1.fc8
- Updated to 0.9.5
- Adds fedora 10 install support (Bruno Cornec)
- Adds Mercurial support in CMS.pm for rinse project (Bruno Cornec)
- Fix a bug in pb for lintian debs, packages and changes are one directory up (Bryan Gartner)
- Adds pb_cms_mod_svn_http function to support fossology https svn checkout with svn+https syntax in URLs (Bruno Cornec)
- Fix a bug with newproj and the late declaration of PBTPM (Bruno Cornec)
- Improve newver for fedora older versions (Bruno Cornec)
- Improve newver and pbcl management in order to only touch created files, not original ones (Bruno Cornec)
- Adds links for gentoo to point on the repo to the latest version of the ebuild (Bruno Cornec)
- Change pb_announce interface (Bruno Cornec)
- Pass verbose level to pb launched in virtual environments/machines (Bruno Cornec)
- Fix a bug on package name detection on Ubuntu (dpkg-deb output different from the Debian one !) (Bruno Cornec)

* Mon Sep 29 2008 Bruno Cornec <bruno@project-builder.org> 0.9.4-1.fc8
- Updated to 0.9.4
- Add support to Website delivery - Fix #30 (Bruno Cornec)
- Add pb_web_news2html which generates news from the announces DB (Bruno Cornec)
- Debian packages are now working - Fix #26 and #33 (Bruno Cornec/Bryan Gartner)
- Add support for specific naming conventions such as perl modules - Fix #32 (Bruno Cornec)
- Preserve by default original tar files got by http or ftp to allow for checksum consistency - Fix #31 (Bruno Cornec)
- Fix CVS export function to also use tags passed in param (Bruno Cornec)

* Thu Aug 07 2008 Bruno Cornec <bruno@project-builder.org> 0.9.3-1.fc8
- Updated to 0.9.3
- Update pb to install VMs correctly with new perl deps Locale-gettext (Bruno Cornec)
- Filtering functions now handle also pointer on hashes (such as the new pb hash) (Bruno Cornec)
- Filtering functions support new macro for patch support (PBPATCHSRC and PBPATCHCMD) (Bruno Cornec)
- Filtering functions use a single pb hash which contains the tag that will be handled during the filtering (Bruno Cornec)
- Env.pm now generates correct templates for patch support and uses the new pb hash (Bruno Cornec)
- pb_cms_export extended to support file:// URI, and also supports an undef second param (no local export available) (Bruno Cornec)
- In pb, hashes now include also the arch (for better patch support) (Bruno Cornec)
- Working patch support added to pb - tested with buffer - Fix #28 (Bruno Cornec)
- pb supports local CMS based patches, as well as external references (not tested yet) (Bruno Cornec)
- New pb_get_arch function provided (Bruno Cornec)
- DBI is only required when using announce (Bruno Cornec)
- When using pb 0.9.3, VMs should also use pb 0.9.3 for compatibility issues (2 tar files, arch in names, perl deps) (Bruno Cornec)
- All global variables are prefixed with pb (Bruno Cornec)
- Makes script execution verbose (Bruno Cornec)
- Improve Fedora official package build (Bruno Cornec)
- Allow subject modification for announces (Bruno Cornec)
- Add support options per VM - Fix #27 (Bruno Cornec)
- Allows pbcl files to not have info on the new version and add it on the fly for newver action (Bruno Cornec)
- Adds support for pbml and pbsmtp at creation of project (Bruno Cornec)
- Use Mail::Sendmail instead of mutt to deliver mail (From: header issue) (Bruno Cornec)
- Announce is now supported in pb (Bruno Cornec)
- Adds support for repositories (yum, urpmi and deb) - Fix #13 (Bruno Cornec)
- Support perl eol separator ($/) in macros. (Useful for PBDESC) (Bruno Cornec)
- Fix an issue of generation on redhat and rhas2.1 where _target_platform in %configure is incorrect (Bruno Cornec)
- pb now generates testver in the .pb for newproj (Bruno Cornec)
- Sort output of build files (Bruno Cornec)
- Adds pbrepo entry when using newproj (Bruno Cornec)
- Add pb_cms_add function (Bruno Cornec)
- Change interface of pb_cms_checkin (third param) (Bruno Cornec)
- Check presence of inittab before touching it in setupvm (Bruno Cornec)
- Fake Changelog for test version (Bruno Cornec)
- setupvm improved with init level 3 by default (Bruno Cornec)
- still issue for pb build on Debian with the devel version name, and the mixed cases for modules unallowed (Bruno Cornec)
- Adds support for multi VM for setupvm command (Bruno Cornec)

* Tue May 13 2008 Bruno Cornec <bruno@project-builder.org> 0.9.2-1.fc8
- Updated to 0.9.2
- Fix DateManip latest version (Bruno Cornec)
- Add preliminary Slackware build support (Bruno Cornec)
- Fix #23 Improve speed by not getting CMS logs if testver (Bruno Cornec)
- Option UserKnownHostsFile of ssh used by default now (Bruno Cornec)
- Now removes pbscript at the end of execution (Bruno Cornec)
- Changes filtering interface to add pbrepo keyword support and PBREPO macro (Bruno Cornec)
- Partly solves #13 by adding repository generation support + conf files to pb for rpm with yum and urpmi (Bruno Cornec)
- test directory is now in a complete separate tree - allows recursive repository support (Bruno Cornec)
- Fix a bug in the VM pb's account for ssh (Bruno Cornec)
- Improved pbdistrocheck to support -v flags (Bruno Cornec)
- Move the pb_env_init function to a separate module to allow pbinit usage (Bruno Cornec)
- Adds support for a build system conf file under $vmpath/.pbrc or $vepath/.pbrc (Bruno Cornec)

* Sun Apr 20 2008 Bruno Cornec <bruno@project-builder.org> 0.9.1-1.fc8
- Updated to 0.9.1
- split of functions from pb to perl-Project-Builder (Bruno Cornec)
- Documentation of functions (Bruno Cornec)
- Prepare conf file management to manage more conf files for build system, ... (Bruno Cornec)

* Mon Apr 07 2008 Bruno Cornec <bruno@project-builder.org> 0.9.0-1.fc8
- Updated to 0.9.0
- Fix #20 newver comment testver and checks pbcl files (Bruno Cornec)
- newver updated to support external CMS repo for build files (Bruno Cornec)
- setupvm ok for all supported distro but slackware not yet supported by pb (Bruno Cornec)
- Fix build2vm where the new name of the distro wasn't correctly handled when trying to get packages pushed to the ftp server. (Bruno Cornec)
- pb_env_init does just setup env variables now. It does CMS checks and conf only if called on a CMS opration (Bruno Cornec)
- systematic use of ENV VAR for PBPROJVER, PBPROJTAG, PBPACKAGER (Bruno Cornec)
- new function to get package list for cms only context and the old one is simplified (Bruno Cornec)
- $DESTDIR/pbrc contains now aal the keys needed to be independant when building - pbroot, pbprojver, pbprojtag, pbpackager. (Bruno Cornec)
- remove ntp calls for the moment, not ready (Bruno Cornec)
- new idempotent setupvm/setupve actions to prepare the VM/VE to be used by pb (Bruno Cornec)
è Numerous fixes in the new way of working to have a full suite working for netperf, pb and mondorescue - newver, cms2build, build2pkg, pbcl, setupvm, build2vm (Bruno Cornec)
- separation of CMS calls (only when using a cms2... action) and the environment variables used (Bruno Cornec)
- Improvements for CMS support, lots on CVS (Bruno Cornec)
- Use pod for pb documentation, modules to be done (Bruno Cornec)
- Use Getopt::Long and support now long options (Bruno Cornec)
- pb_syntax now uses pod2usage (Bruno Cornec)
- All modules are packages now (Bruno Cornec)
- pb_changelog back in Base.pm and removal of Changelog.pm (Bruno Cornec)
- Major changes following a memorable Fort Collins discussion which makes that version incompatible with previous ones (Bruno Cornec/Bryan Gartner/Junichi Uekawa)
- Support URLs for pbconf and projects (ftp, http, svn, cvs, file) (Bruno Cornec/Bryan Gartner)
- Adds Virtual Environment support (mock, pbuilder, ...) (Bruno Cornec/Bryan Gartner)
- Documentation of concepts (Bruno Cornec)
- Fix for debian build in case a debian dir/link already exists in the project (Bruno Cornec/Bryan Gartner)

* Thu Feb 07 2008 Bruno Cornec <bruno@project-builder.org> 0.8.12-1.fc8
- Updated to 0.8.12
- Adds support for supplemental files in projects (Bruno Cornec)
- Addition of pbproj as a filtered variable for dploy needs also in pb_filter_file (Bruno Cornec)
- fix #9 (Bruno Cornec)
- adds gentoo support (Bruno Cornec)
- Removes AppConfig dependency by using just a perl regexp instead (Bruno Cornec)
- support for #11 test versions (Bruno Cornec)
- overall ChangeLog support (Bruno Cornec)

* Sun Nov 11 2007 Bruno Cornec <bruno@project-builder.org> 0.8.11-1.fc8
- Updated to 0.8.11
- Do not continue with VM if something goes wrong (Bruno Cornec)
- Also build on 64 bits VMs when all (Bruno Cornec)
- pb_env_init now creates a pbconf template dir if asked for (newproj option fix #3) (Bruno Cornec)
- Fix a bug in build2vm where only the first parameter was taken in account, so we were only generating the first package (Bruno Cornec)

* Tue Oct 30 2007 Bruno Cornec <bruno@project-builder.org> 0.8.10-1.fc8
- Updated to 0.8.10
- pbinit is now filtered before being used (Bruno Cornec)
- Ubuntu 7.10 support added (Bruno Cornec)
- pbinit executed after filtering (Bruno Cornec)
- Fix bug #7 where .pbrc nearly empty wasn't working (Bruno Cornec)

* Thu Oct 25 2007 Bruno Cornec <bruno@project-builder.org> 0.8.9-1.fc8
- Updated to 0.8.9
- Fix a bug for support of PBLOG = no (Bruno Cornec)

* Thu Oct 25 2007 Bruno Cornec <bruno@project-builder.org> 0.8.8-1.fc8
- Updated to 0.8.8
- Add correct support for PBLOG = no (Bruno Cornec)

* Tue Oct 23 2007 Bruno Cornec <bruno@project-builder.org> 0.8.7-1.fc8
- Updated to 0.8.7
- Fix #2 (Bruno Cornec)

* Mon Oct 22 2007 Bruno Cornec <bruno@project-builder.org> 0.8.6-1.fc8
- Updated to 0.8.6
- Add Debian build support (Bruno Cornec)
- New filtering rules (Bruno Cornec)
- Add flat support to svn and cvs (Bruno Cornec)
- Fix #4  (Bruno Cornec)

* Tue Oct 16 2007 Bruno Cornec <bruno@project-builder.org> 0.8.5-1.fc8
- Updated to 0.8.5
- First public version (Bruno Cornec)

* Thu Jul 26 2007 Bruno Cornec <bruno@project-builder.org> 0.5-1.fc8
- Updated to 0.5
- Creation of the project based on mondorescue build tools (Bruno Cornec)


