#
# $Id: mondo.spec 1892 2008-03-22 00:57:27Z bruno $
#

Summary:	MondoRescue is a GPL Disaster Recovery and Cloning Solution
Summary(fr):	Un programme pour créer un media de sauvegarde/restauration
Summary(it):	Un programma per utenti Linux per creare un CD/tape di rescue
Summary(sp):	Un programa por crear una CD/cinta de restoracion/rescate

Name:		mondo
Version:	2.2.9.6
Release:	1.rh9
License:	GPL
Group:		Applications/Archiving
Url:		http://www.mondorescue.org
Source:		ftp://ftp.mondorescue.org//src/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(id -u -n)
BuildRequires:	newt-devel >= 0.50, gcc-c++, autoconf, automake, libtool
ExcludeArch:	ppc
 
Requires:	mindi >= 2.0.7, bzip2 >= 0.9, afio, mkisofs, binutils, newt >= 0.50, buffer, cdrecord,  
%ifarch ia64
Requires:	elilo, parted
%else
Requires:	syslinux >= 1.52
%endif

%description
MondoRescue is a GPL Disaster Recovery and Cloning solution to create backup media
(CD, DVD, tape, network images) that can be used to redeploy the
damaged system, as well as deploy similar or less similar systems.
MondoRescue is reliable. It backs up your Linux server or workstation to
tape, CD-R, CD-RW, NFS or hard disk partition. In the event of catastrophic
data loss, you will be able to restore all of your data [or as much as you
want], from bare metal if necessary. MondoRescue is in use by numerous blue-chip
enterprises and large organizations, dozens of smaller companies, and tens of
thousands of users.
.
MondoRescue is comprehensive. MondoRescue supports LVM, RAID, ext2, ext3, JFS, XFS,
ReiserFS, VFAT, and can support additional file systems easily. It supports
adjustments in disk geometry, including migration from non-RAID to RAID. MondoRescue
runs on all major Linux distributions and is getting better all the time. You
may even use it to backup non-Linux partitions, such as NTFS.
.
Homepage: http://www.mondorescue.org

%description -l fr
Objectif
""""""""
Mondo est une solution GPL de sauvegarde en cas de désastre pour 
créer des médias (CD, DVD, bande, images réseau) qui peuvent être 
utilisés pour redéployer le système endomangé, aussi bien que des 
systèmes similaires, ou moins similaires.

%description -l it
Scopo
"""""
Mondo e' un programma che permette a qualsiasi utente Linux 
di creare un cd di rescue/restore (o piu' cd qualora l'installazione 
dovesse occupare piu' di 2Gb circa). Funziona con gli azionamenti di
nastro, ed il NFS, anche.

%description -l sp
Objectivo
"""""""""
Mondo es un programa que permite cualquier usuario de Linux a crear una CD
de restoracion/rescate (o CDs, si su instalacion es >2GO aprox.).  Funciona 
con cintas y NFS, tambien.

%prep
%setup -q

%build
%configure
make %{?_smp_mflags} VERSION=%{version}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
mkdir -p $RPM_BUILD_ROOT/%{_var}/cache/%{name}

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc ChangeLog 
#svn.log
%doc INSTALL COPYING README* TODO AUTHORS NEWS*
%doc docs/en/mondorescue-howto.html docs/en/mondorescue-howto.pdf

%{_sbindir}/*
%{_datadir}/%{name}
%{_mandir}/man8/*
%{_var}/cache/%{name}

%changelog
* Tue Apr 12 2011 Bruno Cornec <bruno@mondorescue.org> 2.2.9.6-1
- Updated to 2.2.9.6
- Improved message for Arch Linux for rebuilding the initrd (MC)
- Accept to work with either wodim or cdreord and genisoimage or mkisofs (Bruno Cornec)
- Avoids coredump again when exclude_path is NULL with mr_make_devlist_from_pathlist (MC/Bruno Cornec)
- Fix a seg fault bug when using the GUI in case exclude_paths was NULL (MC)

* Sun Feb 27 2011 Bruno Cornec <bruno@mondorescue.org> 2.2.9.5-1
- Updated to 2.2.9.5
- Do not create an error when a phys device has 0 size and is a /dev/dm-* device (Bruno Cornec)
- Excluding vmhgfs FS for VMWare guests mounting areas of the host. (Bruno Cornec)
- Fix #444. mondoarchive now supports inclusion/exclusion of dirs with spaces in their name. this required a syntax change for the -E/-I options where the list of dirs needs to be separated by '|' now instead of ' '. (Bruno Cornec)
- Fix a bug when no -E option is given on CLI (null) string generated (Bruno Cornec)
- Backport from 2.2.10 the support of a dynamic exclude_path variable. Should help fix #366, #421, #368, #371, #443 (Bruno Cornec)
- Exits if the protocol used is not recognized (error with -n fs:// typo) (Bruno Cornec)
- Fix a bug on exclusion of path with common content (/home and /path/home e.g.) which was handled correctly only in a certain order (John Pearson)
- mount-media function is now placed in libmondo-devices.c as used by more programs. (Bruno Cornec)
- Avoids calling mount_media when it's not mandatory (change the way mondorestore was working up to now but could solve some bugs reported) (Bruno Cornec)
- Fix #412 by using grub.unsupported correctly before grub-install as both exist on opensuse 11.2 (Bruno Cornec)
- Try to provide a workaround in code to the #401 (over-allocation of space due to rounding errors) (Bruno Cornec)
- Fix a bug when using ACLs and file with spaces in their names by adding double quotes in getfacl invocation (Tom Mortell)
- Attempt to fix problem of slowdown in filelist creation by re-introducing a limit to the find command (Bruno Cornec)
- Improves logging for external binary (Bruno Cornec)

* Wed Jun 09 2010 Bruno Cornec <bruno@mondorescue.org> 2.2.9.4-1
- Updated to 2.2.9.4
- Attempt to fix problem of slowdown in filelist creation by re-introducing a limit to the find command (Bruno Cornec)
- Remove a wrong usage of mr_strcat with exclude_path in the 2.2.9 version (probably cause of #421) (Bruno Cornec)
- netfs_proto should be initialized in every case, not just in DR (should solve remaining NULL reports) (Bruno Cornec)
- Avoid to have multiple similar calls to mkisofs by using macros (Bruno Cornec)
- Mondoarchive should not try to create a cmp binary if it doesn't exist (Bruno Cornec)

* Mon Apr 12 2010 Bruno Cornec <bruno@mondorescue.org> 2.2.9.3-1
- Updated to 2.2.9.3
- Fixes for #414: remove comments from grub conf file if used and improve grub conf file generation (Bruno Cornec)
- Fix #412 by supporting grub-install.unsupported for OpenSuSE and solving an issue with the parameter passed to grub for device which should be a device name, not a partition (Bruno Cornec)
- Put an explicit notice of MondoRescue's license: GPLv2 or later (as per Hugo's notice in sources) (Bruno Cornec)
- Fix an initialization bug for network protocol in interactive mode (was NULL and not NFS by default) (Bruno Cornec)
- Try to fix #397 by improving exclusion of binded /proc mount with "none" fs type exclusion (Bruno Cornec)
- Fix #392 by freeing the sz_devfile fifo for ntfs later as it was used in between, causing a problem to backup NTFS dev (Bruno Cornec)

* Fri Feb 05 2010 Bruno Cornec <bruno@mondorescue.org> 2.2.9.2-1
- Updated to 2.2.9.2
- Fix #388: SElinux (and ACLs + xattrs) are now supported fully (Bruno Cornec/Kevin Ritzenthaler)
- Improves device exclusion for LVM (support for symlinks, mapper at all levels: PV, VG, LV, and new boot option excludedevs) and fixes #381, #382, #384, #385 (Bruno Cornec)
- Fix #383 by using pvdisplay instead of relying on 8e as partition type (Bruno Cornec)
- Exclude rpc_pipefs type of filesystems from find (Bruno Cornec)
- Adds the --rescue flag to ntfsclone (Andree Leidenfrost)
- Replace some sprintf by mr_asprintf to add dynamic memory management (Bruno Cornec)
- Fix #377: Segfault in pause_and_ask_for_cdr() (ggeens)
- Fix a bug when isodir is / only when splitting it in iso_path and iso_mnt (Kennedy Doss/Bruno Cornec)
- Fix #375 mondo will segfault if the partition in sensibly_set_tmpdir_and_scratchdir() is read-only (cylau)

* Sat Nov 28 2009 Bruno Cornec <bruno@mondorescue.org> 2.2.9.1-1
- Updated to 2.2.9.1
- /dev/shm is now part of the default exclude list (Bruno Cornec)
- Default to DVD size when in iso or netfs mode (Bruno Cornec)
- Fix #363 where exclude_paths was extended up to memory limit dumping core (Bruno Cornec)
- Fix #367 - the for loop doesn't make any test now, as it was computed before entering the loop, leading to an error, and was also made inside the loop anyway (Bruno Cornec)
- If using nolvm boot param option, mondorestore should also not analyze and handle i-want-my-lvm (Bruno Cornec)
- Reset an error counter before blanking a DVD to avoid always returning an error (Vincent Raman)

* Fri Oct 09 2009 Bruno Cornec <bruno@mondorescue.org> 2.2.9-1
- Updated to 2.2.9
- Adds support for grub2 conf file grub.cfg in addition to menu.lst (Bruno Cornec)
- priority given to env var for tmpdir (Bruno Cornec)
- fuse FS excluded from tmpdir computation (Bruno Cornec)
- DSF now also supports partitions in addition to full disks (Bruno Cornec)
- Adds Fuse SSHFS support at restore time (Bruno Cornec)
- Excluded devices are now handled fully (with bkpinfo->exclude_devs), including in LVM (Bruno Cornec)
- Change NFS support into a generic NetFS support. keyword changed from nfs... to netfs... and proto added (Bruno Cornec)
- star only supports ACL when used with exustar mode. Fix #356 (Bruno Cornec)
- Modify getfattr call to have all extended attributes, including non user ones. Fix #357. (Kevin Ritzenthaler)
- Avoid asking the Prefix name in NFS mode twice (Bruno Cornec)
- Fix a case where the NFS dir in restore mode was mounted rw (linked to bug #291) (Bruno Cornec)
- Solve tmp dir creation which sometimes was trying to create /%xx dirs. Fix #293. (Bruno Cornec)
- Removes some memory leaks with valgrind usage (Bruno Cornec)
- Improve dynamic memory allocation with mr_asprintf (Bruno Cornec)
- Remove all the most obvious bad call to strcat and replace by mr_strcat as appropriate (Bruno Cornec)
- Remove the iamhere function (Bruno Cornec)
- Remove mr_string.c|.h useless and in duplication with mr_str.c|.h (Bruno Cornec)
- Use new libmr.a in build process (Bruno Cornec) 
- Fix a bug (seg fault) when a too large mountlist was used (Bruno Cornec)
- Adds test program for mountlist and truncate_to_drive_name (Bruno Cornec)
- Add support of user for NFS write and fixes #316 (Bruno Cornec)
- mount the NFS dir in mondoarchive, if not already mounted, but present in fstab and fixes #304 (Bruno Cornec)
- Usage of partprobe at restore time if possible (Bruno Cornec)
- Allow the possibility to enter temp and scratch dir in the newt interface. Fixes #326. (Bruno Cornec)
- Protection of chains (file names) passed to system with mr_stresc which may contain strange chars (Bruno Cornec)
- Improve autoconf cuild process (Bruno Cornec)
- Some SuSE have ramdisk as modules, so modprobe brd first before testing for ramdisk presence (Stephan Lauffer)
- Security fix for a remaining /tmp hard coded reference which shouln't have a small potential impact for mondo-prep.c as the file was removed before being recreated and usage is very short (Gentoo/Bruno Cornec)
- Fix lack of formating (discovered by the new Mandriva build process) (Bruno Cornec)
- Create a new define for MAX_MOUNTLIST_ENTRIES and increse MAX_TAPECATALOG_ENTRIES to solve a reported limit (Bruno Cornec)
- Adds support of special partiion names (ida, cciss, mapth) for format-and-kludge-vfat (Bruno Cornec)
- Fix a bug where partition number was wrong for mpath type of dev (Bruno Cornec)
- Remove the maxdepth param in find to take in account deeply mounted proc file systems (Bruno Cornec)
- Fix bugs on array size reported by SuSE build system (Stephan Lauffer)
- Fix a very old bug for partiion labelling after restoration where a fstab with empty lines was causing the script to abort. (Ward Mundy/Bruno Cornec)
- Deliver again the format-and-kludge-vfat script (Bruno Cornec)
- Fix NTFS support at restore time (Conor Daly)
- Really fix the Ubuntu issue with a separate /var this time (Bruno Cornec)

* Wed Feb 04 2009 Bruno Cornec <bruno@mondorescue.org> 2.2.8-1
- Updated to 2.2.8
- Exclude in the file list all FS of type proc and sysf (Bruno Cornec)
- iso9660 type of FS should not be used to create temp dir (Bruno Cornec)
- support latest Ubuntu where /var is a separate FS - see [2128] (Bruno Cornec)
- Use forced USB device through Boot CLI, instead of taking what is in the conf file (Bruno Cornec)
- Do not limit the PATH variable length anymore (Dale Marinenko/Bruno Cornec)
- Improve function truncate_to_drive_name to support returning full drives used as partitions (Bruno Cornec)
- Adds support of ntfs-3g as good format (Bruno Cornec)
- Adds nfs4 support (Bruno Cornec)
- Remove some static allocation in a recursive function - save memory (Bruno Cornec)
- Use /boot/grub/menu.lst everywhere instead of messing up with /etc/grub.conf (Bruno Cornec)
- Adds support for initrd regeneration at restore time (Bruno Cornec)
- Fix #302 adds ext4 support (Bruno Cornec)
- Fix a bug on ia64 where an attempt to create boot.b was made (Giuseppe Grassi/Bruno Cornec)
- Fix a bug in a logging message, where format didn't correspond to params thus giving core :-( (Bruno Cornec)
- Improves logging when a compressor is not found (Bruno Cornec)
- Adds multipath support for RHEL 5.2 (Bruno Cornec/Matthieu Losmede)
- Avoids checking writable NFS share in interactive mode (Bruno Cornec)
- Improve logging in when labelling (Bruno Cornec)
- Fix #298 - MA.log.gz gone (Bruno Cornec)
- Fix #291 when restoring interactively from NFS the NFS share is now mounted read-only (Bruno Cornec)
- Use MONDO_CACHE everywhere instead of fixed strings (Bruno Cornec)
- Remove monitas code (Bruno Cornec)
- Adds support for dm devices in truncate_to_drive_name (Bruno Cornec)
- Do not try to create the dummy file on the NFS share when in DR mode as now the NFS share is mounted ro !(Bruno Cornec)
- Avoid erasing mountlist and I-want-my-lvm when already existing (Benoit Donnette/Bruno Cornec)

* Fri Oct 10 2008 Bruno Cornec <bruno@mondorescue.org> 2.2.7-1
- Updated to 2.2.7
- Remove useless function calc_orig_size_of_drive_from_mountlist (Bruno Cornec)
- Removing potential interactive vgremove command (Andree Leidenfrost)
- Fix #252 by removing shm usage in mondo (Bruno Cornec)
- Fix #277 compatibility in live mode with previous versions (Bruno Cornec)
- Add support for labeled reiser FS (Ulrich Tehrani)
- DSF patch modified to so that get_dsf_mount_list only deal with one path passed as param (Bruno Cornec)
- Adds support for OCFS2 file system when formating using the right command in which_format_command_do_i_need
(Bruno Cornec)
- New function get_dsf_mount_list to support devices with -E and -I (Michael Shapiro)
- Protect recursive remove of tempdir with test on the look and feel of that dir to avoid removing blindly useful dir :-( (Bruno Cornec)
- -H should be usable with tapes, especially OBDR ones (Bruno Cornec)
- Replace a 32kB blocksize fix with the internal blaock size, and adds a call to setblk to try to fix #255, which shouldn't break anything (Bruno Cornec)
- Fix for #261 nsspool and nssvol support (sprobst)
- Fix #260 restoring when cancel in non disaster mode was a regression on 2.2.5 (Bruno Cornec)

* Sat May 31 2008 Bruno Cornec <bruno@mondorescue.org> 2.2.6-1
- Updated to 2.2.6
- Exclude gfs type of FS from backup - Fix #135 (Bruno Cornec)
- Adds OBDR support with -o CLI option and interactive mode - Fix #29 (Bruno Cornec)
- Simplify some function interface with bkpinfo global (Bruno Cornec)
- Fix a bug with g_log_level handled as a string in a msg (Bruno Cornec)
- Attempt to fix problem with SuSE 10.2 boot loader not reinstalled - may also fix other SLES issues reported with the same problem - by mounting /proc and /sys in the chroot during mount_all_devices (Bruno Cornec)
- Fix #250 - Automatic restore with tape is asking questions (Bruno Cornec)
- Fix #244 by ignoring SIGPIPE during big file restore with gzip (Bruno Cornec)
- Renaming of files to be in conformity with stable and ease aplication of patches between branches (Bruno Cornec)
- Fixing broken NFS support in 2.2.5 for rhel5 at least (Kyle Johnson/Bruno Cornec)
- Fix for gentoo (Francesco Talamona/Bruno Cornec)
- Remove all code related to floppies (Bruno Cornec)
- Do not mess with modules.conf anymore. Just use what is in deplist.txt (Bruno Cornec)
- Sharing mondo-cli.c from mondoarchive as libmondo-cli.c for both mondoarchive and mondorestore (Mark Pinkerton)
- Apply patch mondo.live-nfs.patch (Mark Pinkerton)
- Apply a modified version of mondo.libmondo-cli.patch (Mark Pinkerton)
- Extract of mandatory files is now under ./tmp/.. instead of tmp/.. as we use tar to create the all.tar.gz (Bruno Cornec)
- Removes the useless uid field of the mountlist_line struct (Bruno Cornec)
- Some valgrind fixes (Bruno Cornec)

* Sat Mar 22 2008 Bruno Cornec <bruno@mondorescue.org> 2.2.5-1
- Updated to 2.2.5
- Remove floppy support from mondo (Bruno Cornec)
- mondoarchive now really excludes /tmp by default (Bill R. Williams)
- Postpone removal of tmpdir to avoid error messages at end (Bruno Cornec)
- Replace some sprintf by asprintf, searching for a core dumped bug at restore time (Bruno Cornec)
- Gentoo ebuild fixes Cf: http://bugs.gentoo.org/show_bug.cgi?id=176738 (Francesco Talamona)
- Adds the possibility to increase debug level at restore time with a -K option (Bruno Cornec)
- Fix BigFile support when one bigfile is deleted during the archiving (Bruno Cornec)
- Fix NFS mount problem (Bruno Cornec)
- Removal of locate usage completely from code to use find (Bruno Cornec)
- Never tries to eject a NFS media (Brian McKee)
- Only ask for size in NFS mode at backup time (Brian McKee)
- Adds support for alb/aft types of bonding on Intel cards (Mark Pinkerton)
- Adds Fedora 8 and Ubuntu 7.10 build support (Bruno Cornec)
- Do not mount /boot if it's already mounted - avoids ESX hang (Bruno Cornec)
- Use RESTORE consistently across mondo to restore without interaction (Takeshi Shoji/Bruno Cornec)
- Remove dummy file created on NFS (Arnaud Tiger/Bruno Cornec)
- Adds full UUID support, especially with Ubuntu 7.10 (Bruno Cornec)
- Create MONDO_CACHE and use it everywhere + creation at start (Bruno Cornec)
- Add USB Key button to Menu UI (CD streamer removed) (Bruno Cornec)
- Add USB disk/key support (Bruno Cornec)
- Attempt to fix error messages on tmp/scratch files at the end by removing those dir at the latest possible (Bruno Cornec)
- Fix a bug linked to the size of the -E param which could be used (Arnaud Tiger/René Ribaud)
- Build process adapted to use pb http://trac.project-builder.org (Bruno Cornec)
- Fix #137 and #3 issue with large exclude list (> 1000 chars) (Bruno Cornec)
- Fix #191 edition of mountlist in compare mode (Bruno Cornec)
- Fix partially #197 count deleted files in compare (Scott Cummings/Bruno Cornec)
- Fix some some valgrind errors (Bruno Cornec)
- Fix a bug where df was using locale to print messages and wasn't filtered correctly (Bruno Cornec)
- Add mkdtemp checked in configure (Bruno Cornec)
- reset_bkpinfo creates a tmpdir with mkdtemp in setup_tmpdir, takes in account TMPDIR and TMP (Bruno Cornec)
- Render bkpinfo global (Bruno Cornec)
- Use bkpinfo->tmpdir instead of /tmp or MINDI_CACHE when appropriate to fix security issues (Andree Leidenfrost/Bruno Cornec)
- replace vi with find_my_editor during restore (Andree Leidenfrost)
- Fix #195 broken Compare with gzip (Scott Cummings)
- Fix #194 automatically rebooting at the end of PXE restore process (Bruno Cornec)
- Fix #190 mondo-restore replaced by mondorestore (veelo)
- /tmp => /var/log for mondorestore.log (Bruno Cornec)
- Fix gentoo issues again (Francesco Talamona)
- Fix #187 Non-matching file list doesn't work in GUI mode in Compare mode (Scott Cummings)
- Fix a bug in interactive mode on ia64 where lilo wasn't forced (Bruno Cornec)
- Add support of Debian ia64 (Bruno Cornec)
- Improve ia64 support for SLES (Bruno Cornec)
- Fix #179 core dump (Bruno Cornec)
- Add the possibiilty to edit in interactive mode mtab and device.map for grub (Bruno Cornec)
- Remove blkid cache files after restore to avoid problems in cloning mode (Bruno Cornec)
- Fix #185 buggy hack-fstab for LABEL and UUID support (Bruno Cornec)

* Fri Jul 06 2007 Bruno Cornec <bruno@mondorescue.org> 2.2.4-1
- Updated to 2.2.4
- Size of DVD is 4482 (or more surely 4480 to avoid problems - used everywhere) (Bruno Cornec)
- New Hardware migration guide with P2V (Eric Montaut/Gallig/Renaud/Bruno Cornec)
- Fix a memory allocation bug where strings were freed to early (Nick Hajek)
- yum support added to ftp server (Mark Nienberg/Bruno Cornec)
- Also computes number of media for NFS backups (Patrick Albert/Bruno Cornec)
- Improve message around ISO directory (Patrick Albert/Bryan Gartner)
- Improved Ubuntu support (Fix #159) (Bruno Cornec)
- Improved VMWare ESX supoprt (Amaury Tanquerel/Bruno Cornec)
- Fix a bug (hang #136) when no floppy available (Bruno Cornec)
- Adds OCFS support in -N (Bruno Cornec)
- Reduce log file verbosity in sort phase (Bruno Cornec)
- Fix a spelling error (James Cameron/Bruno Cornec)
- mondo rpm pkg depends on buffer and cdrecord (Vincen Danen/Bruno Cornec)
- Adds -p option support to mondorestore (Fix #114) (Bruno Cornec)
- Adds support for Boot loader in partitions (Fix #117) (Bruno Cornec)
- Fix a bug where Unallocated space was considered as an error (Bruno Cornec)
- MINDI_CACHE set to /var/cache/mindi new location of mindi images instead of /root/images/mindi (Andree Leidenfrost)
- Fix bug #158 (cummings)
- Do not use mindi-boot.2880.img (which may not exist) anymore in mondorestore (Bruno Cornec)
- get_architecture now returns correctly the built arch used (Bruno Cornec)
- Fix a bug in mondoarchive for UUID support of /boot (Bruno Cornec)
- Fix a bug for mountlist creation (UUID wasn't printed)
- Build process now creates yum and urpmi repositories for the respective rpm based distros (Bruno Cornec)

* Thu Apr 26 2007 Bruno Cornec <bruno@mondorescue.org> 2.2.3-1
- Updated to 2.2.3
- Fix a critical bug where bzip2 files where not considered during restore (Dale Tronrud/Scott Cummings)

* Mon Apr 16 2007 Bruno Cornec <bruno@mondorescue.org> 2.2.2-1
- Updated to 2.2.2
- Log files are now consistent: mondoarchive.log for mondoarchive (containing also mindi.log) and mondorestore.log for mondorestore (copied from /tmp (ram) to /var/log (disk) at the end of the restore) (Bruno Cornec)
- Script label-partitions-as-necessary now works correctly for LABEL and UUID (Bruno Cornec)
- Remove useless script compare-me (Bruno Cornec)
- Some FreeBSD fixes (Bruno Cornec)
- Fix a bug where losetup is called with only one parameter (#140) (Bruno Cornec)
- Fix a core dumped when a Big file doesn't exist an can't be created (Nic Watson/Bruno Cornec)
- support UUID in mondorestore (Fix #103) (Bruno Cornec)
- Fix a bug in size computation for cciss and similar devices needing a p before their partition name (Bruno Cornec)
- Fix 2 references to grep -x (Fix for #96) (Bruno Cornec)
- Add build support for Mandriva 2007.1, RREL 5 and Debian 4.0 (Bruno Cornec)
- Fix a bug on is_this_raid_personality_registered (John Pearson/Bruno Cornec)
- Fix a bug with raid5 arrays synchronization (Rémi Bondoin)
- Tape support improvements (Benoit Donnette/Michel Loiseleur)
- Handle no compression + verify correctly (Scott Cummings)
- various HOWTO fixes (Mike Kinney)
- Fix temporarily a bug when a biggiefile > 32MB was compressed below the size
of a slice (16MB) (Michel Loiseleur/Bruno Cornec)
- Better module loading in insmod_crucial_modules (Andree Leidenfrost)
- Improve Gentoo packaging (Linos)
- Small typo fix for mondorestore man page (petes-bugs)
- Small memory management improvements (Michel Loiseleur/Bruno Cornec)
- Store NFS config only once (Bruno Cornec)
- Fix a flaw in libmondo-mountlist.c (there since rev [1] !!) (Bruno Cornec)
- Increased MAX_STR_LEN to 384 to make it divisible without remainder by eight
for 64 bits platforms (Andree Leidenfrost)
- Fix a bug where no bzip2 format file would be found when supporting gzip (Andy Wright)
- CentOS fixes (Andy Wright)

* Sat Dec 23 2006 Bruno Cornec <bruno@mondorescue.org> 2.2.1-1
- Updated to 2.2.1
- Fix a memory allocation bug in gen_aux_list (Klaus Ade Johnstad/Andree Leidenfrost)
- fedora core 6 and suse 10.2 support added in build process (Bruno Cornec)
- Fix a bug where grub.conf was a symlink (Bruno Cornec)
- mondo now supports gzip compression format (-G option) (#113) (Bruno Cornec)
- ACL and XATTR are now NOT backed up anymore by default. Should increase mondoarchive speed. To handle them as before, please use the -z option. Fix Bug #63 (Bruno Cornec)
- Fix a bug in libmondo-fifo.c where potentially no buffer content could let mondo runni ng forever in case of an exception (Bruno Cornec)
- Fix a bug where ps (busybox) and ps (system) do not give PID in the same column (Bruno Cornec)
- TAG is now per package (Bruno Cornec)
- Add CentOS build support (Andy Wright/Bruno Cornec)
- Fix bug #89 (env var were queried too early, and not ncessarily in PXE mode) (Bruno Cornec)
- fix #66 (setfacl not existing => no error) (Bruno Cornec)
- Removal of grep -w|-x during restore as not supported by busybox fixes bug #101 (Alfred Chua/Bruno Cornec)
- Fix a bug with DVD+RW format, when mondo asks for retry without success indifinitely (Mariano Aliaga)
- Fix Bug #90 mondoarchive fails when using space in the prefix (Bruno Cornec)
- Fix Bug #87 LABEL= swap does not come online after mondorestore (Bruno Cornec)
- Source directory for mondo is now src (compatibility with trunk) (Bruno Cornec)

* Wed Oct 04 2006 Bruno Cornec <bruno@mondorescue.org> 2.2.0-1
- Updated to 2.2.0
- start-nfs now exports variables taken from PXE command line to mondo to override parameters during archiving - Fix bug #21 (Bruno Cornec)
- Fix for bug #71 mondo now works correctly on x86_64 (Brendan Bouffler/Bruno Cornec)
- Fix for bug #4 (B. Baumer)
- Fix PXE documentation (Brendan Bouffler)
- Attempt to fix bug #25 - bonding support (Michael Shapiro/Bruno Cornec)
- Write start and finish time to log - Fix bug #33 (Bruno Cornec)
- New mr_stresc function to escape commands submitted to system and fixes [[debianBTS(379966)]] (Andree Leidenfrost)
- New files mr_string.c and mr_string.h (v3.0 new organization) (Andree Leidenfrost)
- Fix for [[debianBTS(320152)]] display problem in newt (Andree Leidenfrost)
- Check for grub.conf being a symbolic link (Andree Leidenfrost)
- AFS support (Andree Leidenfrost/Bruno Cornec)
- Better post-nuke handling (first steps) (Andree Leidenfrost)
- Icon for use in menus (Andree Leidenfrost)
- Fix for bug #14 -E switch error (Bruno Cornec)
- Fix for bug #6 mondorestore will ask for prefix during selectve restore (Bruno Cornec)
- Fix for bug #21 prefix taken from PXE server first (Bruno Cornec)
- Fix for bug #24 ps options (Bruno Cornec)

* Fri Aug 04 2006 Bruno Cornec <bruno@mondorescue.org> 2.0.9-1
- Updated to 2.0.9
- Preliminary build process working for Debian and Gentoo (Bruno Cornec)
- New NFS/PXE support. start-nfs is now a fixed script. Allow more possibilities at restore time (Bruno Cornec)
- Fix some compiler warnings for 64bits mode (Andree Leidenfrost)
- Fix various screen corruption for 'Configure LVM'/RAID sync (Andree Leidenfrost)
- SuSE RPMS now use bzip2 (Lars Rupp/Bruno Cornec)
- Exclude ClearCase mvfs type of filesystem from mondo backup (rzonum_at_gmail.com/Bruno Cornec)
- Improved .spec Requires (Fedora/SuSE feedbacks) (Bruno Cornec)
- Indication for users of IDE burners and 2.6 kernels (Christopher Moriarity/Bruno Cornec)
- remove df -P during restore as busybox doesn't support it (Bruno Cornec)
- nfsmount option added to allow redeployment from another NFS server (Bruno Cornec)
- This version should work a bit better with files having special char bug #7421 - but more to come (Bruno Cornec)
- Fix [[debianBTS(369321)]] by increasing MAX_TAPECATALOG_ENTRIES to 8192 and bkpinfo->optimal_set_size to 16MB (Andree Leidenfrost)
- Fix problem with BurnProof+DVD (Andree Leidenfrost)
- Fix bug #7820: mondo should now support files > 2GB (taps23_at_yahoo.com/Bruno Cornec)
- Replaced all occurrences of egrep with 'grep -E' and of fgrep with 'grep -F' (Andree Leidenfrost)
- Optimize grep usage - fixes [[debianBTS(222052)]] (Andree Leidenfrost)
- Avoid false alerts about growisofs not running under sudo (Andree Leidenfrost)
- Increase PPCFG_RAMDISK_SIZE to 350 MB (Thomas Börkel/Bruno Cornec)
- Removed useless mondo-makefilelist (Andree Leidenfrost)
- Fix a segmentation fault in parse_mdstat() (Andree Leidenfrost)
- Fix gcc 4.1.2 warnings (Andree Leidenfrost)

* Wed Jun 07 2006 Bruno Cornec <bruno@mondorescue.org> 2.0.8-3
- Updated to 2.0.8-3
- Fix a bug in -I and -E handling !!  (Paolo Bernardoni <bernardoni_at_sysnet.it>/Bruno Cornec)
- Fix permissions for autorun (Bruno Cornec)
- Fox delivery problems for tar files with too restrictive umask (Bruno Cornec)
- Fix parsing of DHCP information in start-nfs script (Andree Leidenfrost)

* Fri Jun 02 2006 Bruno Cornec <bruno@mondorescue.org> 2.0.8-2
- Updated to 2.0.8-2
- PXE mode now supports change of NIC for redeployment (Bruno Cornec)

* Thu May 25 2006 Bruno Cornec <bruno@mondorescue.org> 2.0.8-1
- Updated to 2.0.8-1
- new build process (Bruno Cornec)
- Fix a bug in .spec for RPM build (attr now unused) (Bruno Cornec)
- Support of dm and LVM v2 (Andree Leidenfrost)
- New mr_strtok functionn added and used for dm support (Andree Leidenfrost)
- Complete doc is now a separate package. mondo still contains the man pages and howto in minimal useful formats (Bruno Cornec)
- HOWTO now contains a new chapter on unattended support for mondo
- Increase size (4 times) of include|exclude variables
- Fix a bug on -I and -E not working with multiple parameters
- Fix a bug in verify for NFS by swapping nfs_remote_dir and isodir when assembling name for image file to verify (Andree Leidenfrost)
- Fix mondo when restoring filenames containing blanks (still a problem for filenames with ') (Bruno Cornec)
- Fix a RPM generation bug for rh7.3 (i386-redhat-linux prefix for binaries) (Bruno Cornec)

* Fri Mar 10 2006 Bruno Cornec <bruno@mondorescue.org> 2.0.7-1
- Updated to 2.0.7
- useless cat, sort|uniq commands removed (Bruno Cornec/Sébastien Aperghis-Tramoni)
- Doc cleanup (Andree Leidenfrost)
- Add the actual format to messages after calls to function is_this_a_valid_disk_format() about unsupported formats.  (Andree Leidenfrost)
- Abort|Warn when one of the include|exclude dirs (-I|-E) does not exist (Bruno Cornec/Jeffs)
- Replaced partimagehack with ntfsclone from ntfsprogs package. (Andree Leidenfrost)
- use df -P everywhere (Bruno Cornec)
- Paypal incitations removed (Andree Leidenfrost)
- mondo now uses /usr/share for the restore-scripts (Bruno Cornec)
- rpmlint cleanups (Bruno Cornec)
- no shared librairies and no X11 anymore (were useless) (Bruno Cornec)
- files > 2GB are now really supported (Andree Leidenfrost)
- new SGML based Mondo Rescue documentation + new Web site (Bruno Cornec/Andree Leidenfrost)
- mondoarchive aborts when 'mindi --findkernel' gives a fatal error (See also [[debianBTS(352323)]].) (Andree Leidenfrost)
- /tmp not excluded anymore from backup (Bruno Cornec)
- New RPM Build environement (Bruno Cornec)

* Fri Dec 23 2005 Bruno Cornec <bruno@mondorescue.org> 2.06-1
- Updated to 2.06
- better error handling of failed commands/mindi (Andree Leidenfrost)
- fix compiler warnings (Andree Leidenfrost)
- -p improvements for NFS/PXE/ISO modes (Bruno Cornec)
- support of default route and netmask for PXE/NFS (Bruno Cornec)
- fix for restoring mondo backups on md-raid systems (Philippe De Muyter)
- remove excessive 'cat' commands (Philippe De Muyter)
- fix to force growisofs to use speed=1 for DVD burning (Philippe De Muyter)
- now handles cifs correctly (Bruno Cornec)
- fix issue where mondoarchive ejects CD/DVD despite writing iso images (Andree Leidenfrost)
- Add -P option to df calls (Andree Leidenfrost/Chuan-kai Lin)
- fix usage of joint -B and -m options (Andree Leidenfrost/Efraim Feinstein)
- Quadrupled ARBITRARY_MAXIMUM from 500 to 2000 for mondorestore's filebrowser (Andree Leidenfrost)
- remove the renice of mondoarchive (Hugo Rabson)
- relocate what was under /usr/share to /usr/lib (FHS compliance) (Bruno Cornec/Andree Leidenfrost)
- manage non ambiguous delivery under /usr (packages) or /usr/local (tar ball) (Bruno Cornec)
- disable x11 build by default (Bruno Cornec)
- remove sbminst (Bruno Cornec/Andree Leidenfrost)
- use parted2fdisk everywhere (Bruno Cornec)
- exports MONDO_LIB (Bruno Cornec)
- RPM build for fedora core 4, sles9, redhat 7.3, rhel 3/4, mandriva 2006.0, mandrake 10.2/10.1 (Bruno Cornec/Gary Granger)
- interactive mode now asks for image size and prefix in NFS mode (Gallig Renaud/Bruno Cornec)
- iso-prefix should be read in iso mode even when -H not given (Stan Benoit)
- VERSION/RELEASE Tag added (Bruno Cornec)
- many code cleanup, small fixes, PXE/NFS code improvements (Sébastien Aperghis-Tramoni/Bruno Cornec)

* Sat Nov 19 2005 Bruno Cornec <bruno@mondorescue.org> 2.05-1
- Updated to 2.05
- -p options works better for NFS cases  (Bruno Cornec)
- ia64 is now working for rhel3  (Bruno Cornec)
- delivery process to BerliOS improved (Bruno Cornec)
- now handles cifs correctly (Bruno Cornec)

* Sun Oct 30 2005 Bruno Cornec <bruno@mondorescue.org> 2.04_berlios-1
- Updated to 2.04_berlios
- Add -p option to generate ISO images file names with prefix. The new default name for ISO images is mondorescue-1.iso, ... For PXE environment, you have to use the prefix option on the command line (read README.pxe) (Bruno Cornec)
- Mandrake 2005 support (Bruno Cornec)
- NFS patches (Yann Aubert <technique@alixen.fr>)
- mondorestore shouldn't now ask final questions with -H (this is an unattended mode) (Bruno Cornec)

* Tue May 03 2005 Bruno Cornec <bruno@mondorescue.org> 2.04-1
- Updated to 2.04
- made mondo more clever about finding its home. Avoids mondo considering directories like '/usr/share/doc/momdo' as its home.

* Wed Sep 29 2004 Bruno Cornec <bruno@mondorescue.org> 2.03-1
- Updated to 2.03
- better SLES8 support
- test user-specified temp dir's sanity

* Wed Jul 21 2004 Bruno Cornec <bruno@mondorescue.org> 2.02-1
- Updated to 2.02
- instead of using 'dd' to erase partition table, delete existing partitions w/ the same call to fdisk that is used to create the new partitions; this should avoids locking up the partition table
- set bootable partition in the above same call to fdisk, for the same reason (avoids locking up the partition table)
- better software RAID support
- mount ext3 partitions as ext2 when restoring - better for Debian
- better star, ACL support
- added ACL, xattr support for afio users

* Mon Jun 21 2004 Bruno Cornec <bruno@mondorescue.org> 2.01-1
- Updated to 2.01
- fixed cvs for SuSE systems
- fixed NTFS backup/restore bug relating to partimagehack log file overflow and NTFS v non-NTFS differentiation
- more reliable extraction of config info from CDs, floppies
- better support of ISO dirs at restore-time (Conor Daly)

* Fri Jun 18 2004 Bruno Cornec <bruno@mondorescue.org> 2.00-1
- Updated to 2.00
- first 2.0 release
- updated grub-install.patched to support SuSE and Red Hat
- added kdelibs as xmondo dependency (Joshua Oreman)
- better find_cdrom_device(), to cope w/ multiple CD writers
- added xmondo pixmap installation
- fixed -m and -Vc flags
- fixed NTFS support!
- bootable CD uses native, not El Torito, support now
- added -devel package
- made xmondo a second package
- added ability to specify --without xmondo at build time
- Clean up, added spanish translation
- Set prefix to be /usr
- added/fixed Requires
- remove CVS directories prior to building
- added 2.6 kernel support
- if 2.6 kernel, insist that the user specify CD device
- drop Embleer; insist on ms-sys and parted if Windows partition
- added support for boot/root multi floppies
- call 'mt' to set block size to 32K before opening in/out tape
- updated mondo-prep.c to create each disk's partitions all at once (one call per drive) instead of one call to fdisk per partition
- when extracting cfg file and mountlist from all.tar.gz (tape copy), use block size of INTERNAL_TAPE_BLK_SIZE, not TAPE_BLOCK_SIZE
- added star and rudimentary SELinux support
- fixed lots of bugs
- all logging now goes to /var/log/mondo-archive.log, with symlink to /tmp/mondo-restore.log for restore-time log-tracking
- added grub-install.patched
- removed embleer & other binaries
- added '-b' to specify block size
- added '-R' for star support

* Mon Mar 29 2004 Bruno Cornec <bruno@mondorescue.org> 1.75-1
- Updated to 1.75
- fixed chmod/chown bug (Jens Richter)
- ask user to confirm NFS mountpoint in Interactive Mode
- rewritten format_everything() to make sure LVMs, RAIDs and regular partitions are prepped in the correct order
- better magicdev support
- rewritten external binary caller subroutine
- DVD support added
- better backup-time control gui; offer to exclude nfs if appl.
- fixed multi-tape support
- re-implemented -D and -J
- fixed bug in extract_config_file_from_ramdisk() which affected tape+floppy users
- updated is_incoming_block_valid() to make it return end-of-tape if >300 flotsam blocks
- unmount CD-ROM before burning (necessary for RH8/9)
- fixed some stray assert()'s
- fixed bug in grub-MR (Christian)
- make user remove floppy/CD before restoring interactively from tape
- fixed bug in am_I_in_disaster_recovery_mode()
- added code to nuke_mode() to make sure NFS (backup) share is mounted in Nuke Mode
- improved tape device detection code
- better GRUB support
- better logging of changed bigfiles at compare-time
- better NTFS support, thanks to partimagehack-static
- better logging
- rewrote tape-handling code, breaking compatibility w/ previous versions
- fixed ISO/CD biggiefile verification bug in mondoarchive
- fixed bug which stopped boot/compare-time changelist from popping up
- replaced mondo-makefilelist with C code - faster, cleaner
- tweaked GUI - better feedback
	
1.74 (2003-09-24)
- fixed biggiefile atime/ctime restoration bug 73
- fixed 'default boot loader' detection bug (Joshua Oreman)
- use single-threaded make_afioballs_and_images() if FreeBSD
- fixed mondoarchive -Vi multi-CD verify bug (Tom Mortell)
- superior get_phys_size_of_drive() (Joshua Oreman)
- fixed RAID-related bug in where_is_root_mounted()
- ISO tweaks
- fixed silly bug in load_filelist() which stopped funny German filenames from being handled properly
- misc fixes (Michael Hanscho's friend)
- added rudimentary support for SME
- added better label support
- fixed various calls to popup_and_get_string()
- fixed spec file
- reject -E /
- added partimagehack to the mix
	
1.73 (2003-05-04)
- mark relevant partitions as bootable _after_ unmounting them
- resolve boot device (-f) if softlink
- post_param_configuration() --- store iso-dev and isodir
- added post-nuke-sample.tgz to package
- Nuke Mode now checks mountlist against hardware; offer user opportunity to edit mountlist if insane; if user declines, abort
- added lots of assert()'s and other checks
- ran code thru Valgrind to catch & fix some memory leaks
- made mondo-restore.c smaller by moving some subroutines to common/libmondo-raid.c and mondorestore/mondo-rstr-compare.c
- added '-Q' flag, to let user test mondoarchive's ability to find their boot loader and type
- improved which_boot_loader()
- when burning or comparing to a CD, defeat autorun if it is running, to avoid confusing mondoarchive and the user
- if original backup media no longer available at boot-time then offer user chance to choose another media source
- when booting, type 'nuke noresize' to nuke w/o resizing mountlist to fill your drives
- add 'textonly' when booting, to avoid using Newt gui
- run nice(20) to prioritize mondoarchive at start
- don't pause and wait for next blank CD at backup-time unless necessary (e.g. previous CD has not been removed)
- get_phys_size_of_drive() --- better support of older drives
- don't eject if "donteject" is in kernel's command line
- cleaned up segfault-handling
- added Conor's strip_path() to improve file list display
- added Herman Kuster's multi-level bkp patch
- added Joshua Oreman's FreeBSD patches x3
- fixed interactive/textonly support
- fixed support for subdir-within-NFS-mount
- fixed "Can't backup if ramdisk not mounted" bug
- try to work around eccentricities of multi-CD drive PCs
- misc clean-ups (Steve Hindle)

* Wed Apr 23 2003 Bruno Cornec <bruno@mondorescue.org> 1.72-1
- Updated to 1.72
- LVM/RAID bugs fixed (Brian Borgeson)
- major clean-up of code (Stan Benoit)
- make-me-bootable fix (Juraj Ziegler)
- fixed problem w/ multi-ISO verify cycle (Tom Mortell)
- removed duplicate entry from makefile
- if root is /dev/root then assume not a ramdisk
- fixed potentially infinite loop in log_to_screen (Tom Mortell)
- reject relative paths if -d flag (Alessandro Polverini)
- add '/' to custom filelist as workaround for obscure bug
- ask user speed of CDRW if writing to CD
- find_cdrom_device() --- if nonexistent/not found then make sure to return '' as dev str and 1 as res
- tweaked restore scripts tgz
- cleaned up find_cdrom_device()
- if user creates /usr/share/mondo/payload.tgz then untar payload to CD at backup-time
- fixed insist_on_this_cd_number()
- fixed am_i_in_disaster_recovery_mode()
- misc clean-up (Tom Mortell)
- made code more legible
- fixed post-nuke support
- fixed nfs support
- fixed iso support
- at restore-time, only sort mountlist internally, in mount_all_devices() and unmount_all_devices() 
- fixed cosmetic bug in label-partitions-as-necessary
- updated documentation
- fixed fstab-hacking scripts

* Fri Apr 04 2003 Bruno Cornec <bruno@mondorescue.org> 1.71-1
- Updated to 1.71
- log newt, slang, ncurses info
- updated man page
- handle double-percent chars in issue.net properly (Heiko Schlittermann)
- fixed serious NFS restore bug
- changed various strcpy() calls to strncpy() calls
- added mondo-makefilelist to makefile (Mikael Hultgren)
- mount_cdrom() better at handling multiple CD drives
- exclude /media/cdrom,cdrecorder,floppy
- sensibly_set_tmpdir_and_scratchdir() --- exclude smb and smbfs
- better logging by eval_call_to_make_ISO()
- accept -J <fname> to let user provide their own fs catalog instead of -I <paths> to backup
- if dir excluded with -E or included with -I and dir is actually a softlink then exclude/include the dir pointed to, as well
- better location for manpage
- adjusted block size of tarball at start of tape, to help users w/ broken tape driver firmware
- sort -u fstab after modifying it
- if backup type is nfs then don't estimate noof media
- fixed Makefile (Mikael Hultgren)
- updated manpage
- added -e support

* Fri Apr 04 2003 Bruno Cornec <bruno@mondorescue.org> 1.70-1
- Updated to 1.70
- new devel branch opened

* Sun Dec 08 2002 Bruno Cornec <bruno@mondorescue.org> 1.52-1
- Updated to 1.52
- fixed bug in multithreading
- use new grub-MR instead of grub-install
- wipe only the partition table (not MBR) when repartitioning drives
- ignore lilo.conf.anaconda when looking for lilo.conf file
- accepts '-l RAW' to backup/restore original boot sector instead of running grub or lilo to init it after restoring
- fixed&updated stabgrub-me script; software RAID + GRUB work now
- mount/unmount /boot partition for Gentoo 1.2 users
- re-enabled extra tape checksums
- disabled spurious warnings
- unmount/remount supermounts at start/end of live restore, if nec.
- cleaned up mondo's tape block handling (now, TAPE_BLOCK_SIZE=128K and I've added INTERNAL_TAPE_BLK_SIZE=32K variable for buffering)
- added Makefile
- added -l RAW option, to backup and restore original MBR
- cleaned up iso_mode() and nfs restoring
- create /mnt/RESTORING/mnt/.boot.d for Gentoo users
- made mondorestore CD bootable for ArkLinux users
- if user runs as 'su' not 'su -' then work around

* Sun Nov 17 2002 Bruno Cornec <bruno@mondorescue.org> 1.51-1
- Updated to 1.51
- pop-up list of changed files, at end of verification phase
- better handling of changed.files list at restore-time
- lots of CD-related fixes
- added '-N' flag --- to let user exclude all NFS-related mounts&devices
- better handling of 'kill'
- restructuring of code to ease integration of mondo w/XMondo
- fixed obscure bug in find_and_mount_actual_cd()
- fixed install.sh
- updated documentation
- fixed .spec file
- if / or /root has <50MB free then abort & complain
- commented code
- updated man page
- added -v / --version flag
- replaced convoluted grep with wc (KP)
- fixed bug affecting restoration of bigfiles from CD's created w/0 compression
- fixed BurnProof-related bug
- better at figuring out which is the best partition to use for temp/scratchdir
- added do-not-compress-these (text file) to RPM
- do not compress files of types listed in do-not-compress-these
- dropped -U from call to afio - saves 20-30 percent runtime (Cosgrove)
- added Cosgrove's do-not-compress-these list
- included various patches from KP
- chmod tmpdir, scratchdir to 700 before using
- restore from specified backup device, even if its own cfg file disagrees
- fixed multi-tape bug
- fixed "Can't find first ISO when verifying nonbootable ISO" bug
- multithreaded make_afioballs_and_images()
- tmpdir and scratchdir set sensibly whether mondoarchive is called with command-line parameters or not
- fixed bug in strip_spaces() which stopped it from handling small strings correctly - affected mountlist editor
- create a repaired copy of grub-install which is RAID-friendly; use it when initializing boot sector with run_grub()
- fixed bug in mondo-makefilelist

* Sun Sep 08 2002 Bruno Cornec <bruno@mondorescue.org> 1.50-1
- Updated to 1.50
- if restoring, don't try to find SCSI node of CD-ROM drive; find /dev entry
- during selective restore, skip filesets which don't contain relevant archives
- set /dev/null's perms to 777, just in case devfs-enabled kernel mangles it
- remove /var/run/*.pid after restoring
- move spurious lockfiles from /home/* to /home/*/.disabled
- ask user to confirm the tape/CD device name
- lots of multitape-related fixes
- added code to autodetect the hardware of the user, when possible
- if isodir does not exist then abort
- doubled 'biggiefile' threshold... to 32MB
- exclude /root/images/mindi
- fixed multi-imagedev bug (Emmanuel Druon)
- unmount/remount /mnt/floppy before/after backing up, if Mandrake
- restructured the source files
- fixed serious bug in line 1546 - should have been !=, not ==; stopped mondorestore from correctly restoring big files
- added '#include <signal.h>' to my-stuff.h
- exclude "incheckentry xwait()" from changed.files
- fixed minor bug in find_cdrom_device()
- fixed bug in friendly_sizestring...
- insist on tape #1 when start verifying
- added internal buffering, replacing the external 'buffer' exe
- if differential backup then don't permit formatting or fdisking, whether Interactive or Nuke mode
- if mondorestore is run on live filesystem (or from ramdisk) without parameters then mondorestore will ask which backup media (tape, CD, etc.) was used; it will read the config file from the media and proceed from there
- if tape streamer is softlink then resolve it first
- incorporate post-nuke tarball
- if user doesn't specify tape size, proceed anyway; behave intelligently in the event of end-of-tape
- prefix bkpinfo->restore_path to biggiefile fname before generating checksum & comparing to archived biggiefile
- if /etc/lilo.conf not found not /etc/lilo.conf.anaconda found then create a softlink from the former to the latter, to work around RH7.3's b0rken LILO support
- LFS support (mharris, michele, hugo)
- fixed verify bug --- CD#1 was being verified again & again & ...
- differential mode fixed; supported again
- ask user for boot loader + device if not detectible
- list up to 512 files in file selection window at once (was 128)
- better handling of bigfiles' checksums, perms and owns
- delete final filelist if <=2 bytes long
- if kernel not found and mondo in graphics mode then popup and ask for kernel path+filename
- misc clean-ups (Troff)
- noninteractivity-related & misc clean-ups (Carl Wilhelm Soderstrom)
- RAID, feedback enhancements (Philippe de Muyter)
- exclude /dev/* from changed.files
- replaced large declarations with malloc()'s and free()'s
- added lockfile
- fixed bugs affecting tape users who backup+verify at same time
- fixed bugs re: tape block size >32K (Troff)
- added signal-trapping to mondoarchive and mondorestore
- fixed bug in new '-s' code
- added --isonuke and --mbr switches
- cleaned up live filesystem restoration
- permit '-0' (no compression) flag
- if user restores selectively (picks some files to be restored) then large files archived during '-L' (LZO) backup will now be restored properly
- fixed bug in make-me-bootable
- don't change /tmp's permissions unless it doesn't exist & has to be created
- changed $i to $j in mondo-makefilelist (Karsten)	
- fixed 'I refuse to write floppy images to /dev/fd0 because its size is not apparent from its filename' bug
- disabled 'nr-failed-disks' entry in raidtab generator
- added '-o' flag to let user choose LILO as CD/floppy's boot loader
- fixed bug in --mbr

* Tue Jun 04 2002 Bruno Cornec <bruno@mondorescue.org> 1.43-7
- Updated to 1.43-7
- afio uses 16MB buffer when restoring, instead of 8MB buffer
- mondorestore makes /var/run/console in case user excluded it
- the -s switch now accepts multiple sizes, one per tape/CD
- added -u switch for streaming to device; like -t (tape) but without various error checks; use with caution
- bugfixes; cleaned up code (Troff)
- changed lockfiles from static to random filenames
- use dvdrecord instead of cdrecord, if available
- don't alter /mnt/RESTORING/tmp's permissions if comparing
- added -follow to search for home (Bruno Vidal)
- unmount/remount CD-ROM at start/end if supermounted
- delete old /tmp/filelist.full,biggielist.txt if restoring to live filesystem
- if Mindi aborted then show last 6 lines of its log before mondoarchive aborts
- reformatted, redistributed source code (Stan Benoit)
- replaced isolinux dependency with syslinux dependency
- now shows the CDR(W)'s progress properly - 20 percent, 30 percent, etc.
- changed lockfiles from static to random filenames

* Fri Apr 12 2002 Bruno Cornec <bruno@mondorescue.org> 1.42-3
- Updated to 1.42-3
- minor cosmetic enhancements
- improved homedir-locating code

* Sun Apr 07 2002 Bruno Cornec <bruno@mondorescue.org> 1.42-1
- Updated to 1.42-1
- mondorestore may now be run on live filesystem, i.e. user does not have to reboot in order to restore data; works for CD's and tapes; NFS and ISO restores will be supported at a later date
- fixed restore-time RAID-handling bugs
- added -E patch to exclude files and/or dirs properly (Andy Glass)
- cat /proc/cpuinfo and run uname -r; save output to logfile at backup-time
- fixed minor bug in stablilo-me
- if /tmp/fstab.new exists then use _it_ instead of /tmp/fstab to label ext2 or ext3 partitions
- bootable CD's now use SYSLINUX instead of LILO (Andy Glass)
- don't pclose() tape after calling closein_tape(): the latter does it already
- tarball installs to /usr/share/mondo by default; was /usr/local/share/mondo
- numerous cosmetic enhancements
- added '-m' (manual CD tray) flag
	
v1.41-1 (2002-03-21)
- record hostname (Krzysztof Dubowik)

* Sun Mar 10 2002 Bruno Cornec <bruno@mondorescue.org> 1.40-7
- Updated to 1.40-7
- if '-L' then test for lzop; abort if not present
- if Mondo cannot figure out which boot loader the user is using, tell the user to read the manual and mention -l, -f switches
- abort if ramdisk not available
- updated man page (Mikael Hultgren)
- support multiple -I params (Mikael Hultgren+Randy Delfs)
- mkreiserfs -ff instead of -q (Andy Glass)

* Sun Mar 03 2002 Bruno Cornec <bruno@mondorescue.org> 1.40-6
- Updated to 1.40-6
- incorporated new config.guess, config.sub (Hï¿½tor Garcï¿½ ï¿½varez)
- updated manual to explain tmpfs needs to be in kernel (Mikael Hultgren)
- don't let non-root users run mondoarchive
- allow up to 50 chars in popup_and_get_string()'s input field
- tell user to use 'su -' instead of 'su' if they use 'su' by mistake
- make mondo-makefilelist more SUN-friendly, re: fstab (Andy Glass)
- modified 'Sliced bigfile #n' log entry to say '..#(n+1)'

* Sun Feb 24 2002 Bruno Cornec <bruno@mondorescue.org> 1.40-5
- Updated to 1.40-5
- improved the way Mondo installs itself (Mikael Hultgren)
- updated manpage
- touch /mnt/RESTORING/var/log/pacct after restoring
- added updated docs (Cafeole, Randy Delfs, Stan Benoit et al)
- added pico to restore-scripts.tgz; deprecated some scripts
- if restoring to /dev/ida/* or /dev/cciss/* then drop the 'p' before trying to discover the size of the partition itself
- support pathnames containing spaces (KirkJT)
- added -C switch, to treat CD burner almost as a tape streamer
- run post-nuke script if it exists
- put (char*)(&buf) instead of &buf when reading/writing biggiefiles' info
	
v1.40-3 (2002-02-17)
- let user exclude devices from mountlist with (e.g.) -E /dev/hda1
- handle one-letter dirs properly (Ian Kent)
- when making ext3 fs, don't specify journal size (Cafeole)
- add tmp.mondo.NNNN to tempdir path, if tempdir is specified by user
- add mondo.scratch.NNN to scratchdir path, if scratchdir is specified by user
- beefed up RAID-related logging a bit
- exclude .journal files properly
- Italian patch (Michael Baldessari)

* Mon Feb 11 2002 Bruno Cornec <bruno@mondorescue.org> 1.40-2
- Updated to 1.40-2
- fixed typo in manpage (Mikael Hultgren)
- exclude "#"*"#" and *~ from tarball and source RPM
- updated manual (Randy Delfs)
- put the correct version# in mondo/my-stuff.h
- in Nuke Mode, expand/contract mountlist proportionately to fill hard disks
- fix serious restore-time bug in tape/afio-handling code
- cdrecord is only required if burning CD's

* Sun Feb 10 2002 Bruno Cornec <bruno@mondorescue.org> 1.40-1
- Updated to 1.40-1
- set partition(s) bootable w/fdisk if appropriate
- cosmetic bugfixes
- changed get_phys_size_of_drive() to read value from fdisk, not dmesg
- if hard disk does not exist then warn user when editing mountlist
- if boot+floppy disk images were not created then don't offer to write them to disks; instead, mention the mindi.iso bootable CD images	
- exclude each partition's .autofsck from backup
- fixed bug in CD restoration progress form
- changed many tempfilenames from mojo-jojo* to sensible, random names
- exclude win386.swp from backup (Cafeole)

* Thu Feb 07 2002 Bruno Cornec <bruno@mondorescue.org> 1.38-2
- Updated to 1.38-2
- minor improvements to the NFS-handling code
- mondo-restore now records Mondo's version# in log
- fixed silly bug that makes 'current filelist #' progress form inaccurate
- fix typo in '10 seconds to abort' line; also, made 20 seconds

* Wed Feb 06 2002 Bruno Cornec <bruno@mondorescue.org> 1.38-1
- Updated to 1.38-1
- source code has been beautified (Stan Benoit)
- makefile, Config implemented (Stan Benoit)
- use /tmp/mondo-restore.cfg instead of all kinds of silly /tmp files at boot-time; slowly migrating to a proper /tmp/mondo-restore.cfg file
- changed 'retval+=load_raidtab()' to 'load_raidtab()'
- patch to make it easier to install Mondo almost anywhere (Ian Mortimer)
- proper, one-char switches replace the long-winded multi-char switches of 1.36 and earlier
- migrating from lots of /tmp files in ramdisk to a single configuration file on ramdisk, at /tmp/mondo-restore.cfg
- estimates the number of media required by this backup session
- changed 'retval+=load_raidtab()' to 'load_raidtab()'
- records+restores biggiefiles' permissions+ownership properly

* Fri Jan 25 2002 Bruno Cornec <bruno@mondorescue.org> 1.37-1
- Updated to 1.37-1
- proper 'selective restore' interface implemented
- if the user specifies boot loader or device, record those settings
- fixed cdrecord-related bug in .spec file
- if backing up specific paths - e.g. /usr/local/bin - then include /usr and /usr/local/ in filelist; don't backup /usr/* but do recreate /usr and /usr/local/; this is to help the selective restore subroutine
- user's BIOS is assumed not to be able to handle LILO's sector-seek merging
- switches --broken-bios, --debug and --chunk-size have been removed
- if user calls with --burn-cds 2 (nothing else) then find CDRW and continue
- if CD writer's speed is not specified then assume 2x
- better autodetection of CD writer
- set size is 5MB for tape users and CD users alike
- exclude /root/images/mondo from backup
- added --skip-floppies switch
- abort if PC has <32MB of RAM at backup-time; warn if <64MB

* Sun Jan 20 2002 Bruno Cornec <bruno@mondorescue.org> 1.36-1
- Updated to 1.36-1
- fixed v.minor bug in MakeFilelist()
- in mondo-archive, replaced calls to Die() with calls to FatalError()
- include .spec file in tarball
- if cdrecord v1.8 or older then abort: inadequate for Mondo's needs
- moved misc functions from mondo-archive to mondo-tarme.c
- prettier interface when preparing and formatting boot+data disks
- when editing mountlist, warn if formats !supported by kernel (B. Hartin)
- don't try to run e2label on filesystems which aren't ext2 or ext3
- don't write to tape if already burning to CD (Kosaku Nagasaka)
- re-enabled and tested some CD-verifying code
- added buffer to RPM/tarball requirements
- set size is 4MB for tape users; 16MB for CD users
- files <16MB aren't chopped
- uses tmpfs for temp storage if backing up to tape
- (rudimentary) selective formatting
- log versions of afio, bzip2, etc.

* Thu Jan 10 2002 Bruno Cornec <bruno@mondorescue.org> 1.35-1
- Updated to 1.35-1
- NFS backup+restore support
- exclude Win2K hiberation file (Paul Rensing)
- fixed filelist.full/filelist.blah typo (Paul Rensing)
- unset TAPE at start of mondo-archive (Norm Crowfoot)
- if bzip is <v0.99 then abort
- if hard disk fills to capacity then abort
- --post-nuke <tarball> will incorporate a tarball of tools and data files of the user's choosing in the boot CD/floppies; the tarball must contain an executable, 'post-nuke', which will be called at the end of Nuke Mode
- --text-mode forces Mondo Archive to use text only (no newt or ncurses)
- the deprecated scripts have now been disabled
- boot floppy will use 'safe' LILO calls; boot CD will use 'fast' LILO calls unless --broken-bios is supplied in call to Mondo
- cdrecord's buffer is now 4 MB (was 16 MB)
- tape support has been rewritten from ground up
- set size is now 16MB for CD users and 48MB for tape users
- don't let user change mountlist entry from regular mountpt to 'image'
- mount -t (space was missing in mount_isodir())
- all calls to afio now use blocks of TAPE_BLOCK_SIZE KB and RAM buf of 8 MB
- added Peter Seidler <p.seidler@mail1.stofanet.dk>'s "Petris" game
- --exclude-paths now drops the trailing '/' from param(s) if present
- tab-align /etc/fstab after hacking it

* Tue Dec 25 2001 Bruno Cornec <bruno@mondorescue.org> 1.34-1
- Updated to 1.34-1
- if /sbin or /usr/sbin are not in PATH then add them temporarily
- if --broken-bios then force LILO to run in backward-compatible mode
- tape users can boot from a single floppy now
- when archiving/restoring/verifying tape, skip the first 32MB
- fixed bugs in actually_verify_the_tapes()
- fixed some popen/pclose mismatches
- no longer run compare_a_biggiefile() right after restore_a_biggiefile(), as it can upset the restoration of biggiefiles which are spread across CD's

* Wed Dec 19 2001 Bruno Cornec <bruno@mondorescue.org> 1.33-8
- Updated to 1.33-8
- implemented --image-devs <dev> (<...>) switch
- improved --verify switch's code
- exclude Windows' win386.swp file, if found
- fixed bug in unmount_all_devices()
- include version of Mondo/Mindi in error log
- updated the FAQ
- when making differential backup, make sure to exclude nonexistent files
- --use-lzo now applies lzo to big files as well as afio archives
- changed all 'long long's to 'off_t's
- no longer aborts if /etc/lilo.conf does not exist
- moved FAQ's to FAQ file
- archive bigfiles one slice at a time; much less wasteful of space
- abort if user tries to backup a mounted partition as an _image_

* Sat Dec 15 2001 Bruno Cornec <bruno@mondorescue.org> 1.33-6
- Updated to 1.33-6
- misc bugfixes

* Fri Dec 14 2001 Bruno Cornec <bruno@mondorescue.org> 1.33-5
- Updated to 1.33-5
- improved error-reporting in the event of boot loader detection failure
- improved tape verification code
- experimental support for backing up and restoring devices as images

* Thu Dec 13 2001 Bruno Cornec <bruno@mondorescue.org> 1.33-4
- Updated to 1.33-4
- updated FAQ
- experimental GRUB support
- when calculating checksums, tell user percent done and time remaining
- checksum catalog entry = filesize+mtime+ctime; don't call md5sum or cksum
- compile mondo-filelistchop and mondo-checksum with -O2 optimization
- when writing floppies, ask specifically for floppy #x (Randy Delfs)

* Wed Dec 12 2001 Bruno Cornec <bruno@mondorescue.org> 1.33-3
- Updated to 1.33-3
- supports --boot-loader and --boot-device to let user specify them
- fixed CDRW node autodetection bug
- MONDO_PATH was misconfigured; is now "/usr/share/mondo"

* Wed Dec 12 2001 Bruno Cornec <bruno@mondorescue.org> 1.33-1
- Updated to 1.33-1
- if user changes a partition's device, change it in raidtab too
- don't extrapolate from /etc/raidtab to /tmp/mountlist; editor does it already
- don't backup /tmp (somewhere in the v1.3x series, I stopped excluding /tmp)
- cosmetic fixes to mondo-prep.c and mondo-newt.c
- put quotes around chmod's parameter
- subtract 5 percent from reported maximum storage capacity of drives, when checking that the parttions will fit; some drives lie about their max cap
- stablilo-me no longer tries to mark partitions as bootable
- better exclusion of /var/log/pacct
- tape users can now use --verify to verify archives w/o rebooting
- checksum calculated for every file backed up - for future expansion
- implemented a _real_ --differential switch, to backup all files changed or added since the last complete backup

* Sun Dec 09 2001 Bruno Cornec <bruno@mondorescue.org> 1.32-2
- Updated to 1.32-2
- if no RAID devices after editing mountlist then delete raidtab
- don't try to mount RAID partitions (components of RAID dev)
- don't add partitions to mountlist when extrapolating from mountlist unless the partitions are not already present in mountlist
- don't format partitions if partitioning failed
- when user selects RAID level, establish whether said level is available

* Sun Dec 09 2001 Bruno Cornec <bruno@mondorescue.org> 1.32-1
- Updated to 1.32
- if user creates ISO images, the default dest dir is /root/images/mondo now
- log_it() makes sure it only writes one \n on the end of each logged line
- detects if user is using GRUB/LILO/other; abort if neither LILO nor GRUB
- passes the boot loader's name and device to Mindi, to be available at boot-time
- if user successfully restores using Nuke or Interactive w/o error then Mondo generates a random message, basically saying, "Cool."
- enlarged afio's "-M" parameter from 12M to 16M
- if stablilo-me fails then restore the original lilo.conf and fstab before offering user the opportunity to edit them (Dean Carpenter)
- added ISO Mode, to let user restore from ISO images in directory
- cosmetic fix to compare/restore phase windows
- if backing up to ISO images then offer to write boot floppies too
- changed some references to /tmp/raidtab, to /etc/raidtab
- cleaned up compare + restore logging
- scratchdir is now [path]/mondo.scratch.$$; was just [path]/mondo.scratch

* Tue Dec 04 2001 Bruno Cornec <bruno@mondorescue.org> 1.31-1
- Updated to 1.31
- turned on '-Wall' to find cruft; found lots of it; cleaned it up
- exclude each device's lost+found directory
- mountlist editor now permits advanced editing of RAID devices
- fixed a silly bug that was causing freeze-up on <1 percent of systems; if biggielist was empty then sometimes mondo-archive would freeze when backing up big files (cos there weren't any *g*)
- partition and set type in 2-stage process (was 1-stage)
- cleaned up Compare Mode's logging a bit, to make it more legible
- don't report changed archives as 'errors' but as 'differences'
- exclude ext3's .journal files from backup (yes, this time I really do)
- '--my-kernel SUCKS' has been replaced with '--my-kernel FAILSAFE'
- softlink mondo-restore to /usr/bin/ before calling Mindi, so that Mindi can pick up mondo-restore and its depdendencies easily
- copy mondo-restore to Mondo's temp dir before calling Mindi
- don't try to compress MP3's, MPG's, WMV's or RA's
- cleaned up mondo-newt.c; alphabetized the subroutines; moved some tools from there to mondo-tools.c
- mondo-tarme and mondo-restore are now compiled as dynamic executables; I have amended install.sh and mondo-1.31.spec accordingly
- now make boot/data floppies at end of backup, not beginning
- backup in alphabetical order now, not reverse-alpha
- if Compare Mode reports changed files /var/* and /etc/mtab only then tell the user their archives are good despite the differneces
- cut back on excessively verbose logging at backup-time
- when vacuum-packing a partition, describe it as "(max size)", not "(0 MB)"
- if swap is already mounted, don't abort: just say, 'swap already mounted'
- when unmounting all devices, don't try to unmount something if it's not even mounted; if it's not mounted, say so but don't try to unmount it: you'll just end up looking very silly :)

* Wed Nov 28 2001 Bruno Cornec <bruno@mondorescue.org> 1.30-1
- Updated to 1.30
- I have reorganized the C code, sorted the subroutines alphabetically, and re-jigged Mondo's installation routines (inc. the RPM spec file) to reflect the changes
- check for mondo-restore's presence; if absent then abort & ask user to check to see if Mondo was installed properly
- always exclude /var/log/pacct from backup
- optimal set size is now 24MB
- install.sh will abort w/error if compilation of mondo-* fails
- after creating the mountlist, put a copy in Mondo's tmp directory
- each ext3 filesystem has a .journal file in its base directory; Mondo will now exclude each of these journal files automatically
- use the archived copy of LILO, not the copy from the restore-time ramdisk, to configure the MBR
- size_of_file() now returns long long, not long
- find mondo-archive and set MONDO_PATH accordingly
- scratchdir is /home/mondo.scratch by default
- at backup-time, run mondo-restore in test mode to make sure that the executable is sane & will run OK at restore-time

* Wed Nov 14 2001 Bruno Cornec <bruno@mondorescue.org> 1.19-1
- Updated to 1.19
- tested on Linux-Mandrake 8.0 and Red Hat 7.2; backup,wipe,restore went OK
- fixed a bug in is_this_device_mounted()
- at restore-time, always check for presence of decompressor; abort if notfound
- run 'chmod -r 1777 /mnt/RESTORING/tmp' after restoring
- fixed bugs in Compare Mode:- - missing else{} - erroneous 'cannot add archive' error; res+=retval should have read retval+=res (Tony Kim)
- use 'umount /mnt/cdrom' instead of 'umount /dev/cdrom', to make it compatible with busybox's umount command
- fixed bug in mondo-archive which stopped Mondo from pausing to retry if the CD/ISO fails the verification phase
- modified compare_all_tarballs() in mondo-restore.c
- if running interactively then offer to modify fstab and lilo.conf if user says s/he has modified the mountlist
- if mondo-tarme segfaults (as it does, on a _very_ few systems) then Mondo picks up on the fact & reports it
- when restoring, create /mnt/RESTORING/tmp before _and_ after restoring data, just in case it is necessary; also set permissions okay
- C code is now compiled 'O0' (without optimizations)
- each CD's slices were being listed to screen; now, piped to /dev/null

* Sun Oct 28 2001 Bruno Cornec <bruno@mondorescue.org> 1.18-1
- Updated to 1.18
- changed minor error in documentation (mondo-archive's --help output)
- improved Mondo's compare phase for tape users

* Sat Oct 20 2001 Bruno Cornec <bruno@mondorescue.org> 1.17-1
- Updated to 1.17
- the deprecated scripts now work with LZO
- if mondo-restore cannot mount all devices, it will _unmount_ whatever it did mount, before it returns an error
- works with Red Hat 6.2 and 2.2.19 kernel
- cosmetic change to output (no more 'burning first/last CD' msgs)
- abort if user uses '--use-lzo' but doesn't install LZO(P) first
- changed --differential's \( and \) to ( and ) <-- thanks, Michael Moellney)
- added Marcus Oberhumer's LZO to Mindi and Mondo; use '--use-lzo' switch to activate this groovy new compression algorithm; it is not as efficient as bzip2 but it is can take up to 50 percent less time than bzip2 to compress data
- incorporated Bruno Cornec's "--cd-recovery" patch
- at restore-time, set biggiefiles to +x
- set optimal fileset size to 16MB (was 8MB)
- don't report non-existent differences/errors between archives and filesystem
- fixed bug in --differential switch (Michael Moellney)
- scripts will no longer function unless gawk and printf are included in Mindi's deplist.txt; add them if you want to use the scripts

* Wed Oct 10 2001 Bruno Cornec <bruno@mondorescue.org> 1.16-1
- Updated to 1.16
- default scratchdir is `pwd`/mondo.scratch.$$ (was mondo.scratch)
- when asking user to send me a log file, warn them that the log file may contain information which they do not want me to see but point out that I cannot help much unless I have a copy of their log file
- when comparing to or restoring from tape, only update the progree form if/when I've just restored files; otherwise, I would screw up the time est.s
- increase afio's block count from 256 to 1024 when restoring from tape
- plays nicely with devfs-enabled kernels and distros
- when restoring or comparing, track progress by the archive# (N out of M), not by the file#; the former is more reliable and useful than the latter
- has been tested successfully with the following distros - Linux-Mandrake 8.1 and its 2.4.8, devfs-enabled stock kernel --- tape / CDR - Red Hat 7.1 and its 2.4.2 stock kernel --- tape / CDR
- tape streamers are now supported; use the '--write-tapes <dev> <sizeMB>' switch, e.g. --write-tapes /dev/st0 4096
- LVM support is stabilizing
- when mounting/unmounting partitions to be restored, don't forget to mount/unmount the swap partitions
- when zeroing a drive, use plain old C fopen/fputc/fclose, not 'dd'
- after restoring data and running LILO, unmount (as usual) and then run label-partitions-as-necessary, to set the ext2fs LABELs if it is appropriate
- fixed bugs in selective restoration scripts and executable
- fixed silly bug in hack-lilo; bug was triggered when I moved to Mandrake 8.1; bug caused '/dev/fd0' entry in lilo.conf to become corrupted
- if user tries to make a bootable rescue CD with the '--no-bkpath' switch then politely direct them to Mindi :-)

* Fri Sep 28 2001 Bruno Cornec <bruno@mondorescue.org> 1.15-1
- Updated to 1.15
- serialized the call to mondo-filelistchop.c; helps to improve visual feedback (yeah, sounds weird but it's true)
- the switches --differential and --exclude-paths should play nicely now
- improved the logging a bit, esp. when ejecting or unmounting CD's
- improved the visual feedback (specifically, the bar and percentage figures indicating time spent & remaining)
- experimental LVM support
- fixed 'cannot eject CD' bug, which was caused by busybox's sync & umount
- fixed mount-me to allow for mountlists with >1 spaces between columns
- fixed documentation; param is --my-kernel <path>, not kernel-path <path>
- fail if user runs mondo-archive _from CD_; this is for the user's protection
- fixed silly bug in mount-me (a crucial line was disabled)
- working on stablilo-me, hack-lilo and hack-fstab to make sure they work with the new, busybox-based Mindi v0.41
- Mindi v0.41 is very different from v0.40, internally anyway; so, I had to do a lot of testing to make sure Mondo would play nicely with the new Mindi

* Tue Sep 18 2001 Bruno Cornec <bruno@mondorescue.org> 1.14-1
- Updated to 1.14
- if verify is enabled then verify each CD/ISO after writing it
- fixed a quasi-bug in mondo/mount-me; this script used 'sort +1' which is not supported by busybox; I've changed it to just plain old 'sort'
- Mondo now tells Mindi whether or not to use its stock kernel
- fixed bug in 'biggify-me' script; now, checksums will be verified
- fixed bug in checksum comparison code (mondo-restore.c)
- reimplemented '--verify' switch; now, user can verify ISO's or CD's against the live filesystem, just for 'belt and braces' emotional security
- improved the error-reporting at restore-time (if tarball cannot be accessed)
- if user does not specify CD-R(W) drive's speed or device then Mondo will try to locate the drive and will assume 4x speed
- user may now type 'edit-mountlist' after booting, if they want to edit the mountlist without risking accidentally wiping their hard disks
- fixed a few silly typos in the error messages in mondo-tarme
- updated the FAQ
- added code to verify ISO images
- used 'blank=fast' instead of '-blank fast' for backward-compatibility with older versions of cdrecord
- if nonzero value returned by Mondo, then Mondo creates a mondo.err.$$.tgz tarball containing log files & stuff, which it tells the user to e-mail me
- when debugging, don't pause before running mondo-tarme; just run it
- automatically exclude any file including '/vmmhiber.w9x' in its pathname
- added Minix support (although I doubt anyone needs it)
- ported mondo-tarme to C - prettier interface at run-time (backup), giving better feedback - obviates a mysterious, intermittent bug in bash itself - shows ' percent done' when burning CD
- afio now has a 12MB FIFO buffer (was 16MB)
- cdrecord now has a 20MB FIFO buffer (was 24MB)
- wipe [CD]/usr/share/mondo, as well as floppy images, if CD #2 or later
- up to 19 CD's may be created now
- fixed the 'stderr.txt not found' loop error in mondo-tarme.c
- fixed the weird 'segfault on finish() after archiving' bug
- modularized the install.sh and mondo-1.14-x.i386.rpm compilation sections

* Sat Sep 01 2001 Bruno Cornec <bruno@mondorescue.org> 1.13-1
- Updated to 1.13
- fixed some compiler warnings in mondo-newt.c; rearranged some code
- mondo-tarme now uses -M 16m -t 4k in its call to afio, to improve performance
- fixed mondo-restore.c's mkreiserfs call; ditto, prep-me's mkreiserfs call
- fixed mondo-restore.c's compare_a_biggiefile() subroutine, which would generate erroneous error messages
- fixed mondo-archive.c's restore_a_biggiefile() and restore_all_biggiefiles() subroutines; I can't get them to break but others can, so I've streamlined the code to make them easier to debug and in theory more stable too
- fixed 'hack-fstab' to make sure that non-LABELed partitions are correctly moved/changed, etc.
- fixed the 'space in big filename' bug (I think)
- make Interactive Mode sort the mountlist (by partition size) before creating the dirs and mounting the partitions to them
- fixed a slew of bugs related to Red Hat's LABEL= extensions
- cleaned up mondo-restore.c and mondo-newt.c; replaced lots of arbitrary limits and lengths with a small number of #define's
- added some sample RAID0/1/5 raidtab (config) files to restore-scripts.tgz, which will be restored to the ramdisk's /etc dir when the user boots from the CD; this will only take up an extra 50K or so & will help any user who is moving from non-RAID to RAID
- changed FIFO size to 20MB
- only use the VFAT kludge on /dev/hda1 or /dev/sda1; otherwise, even if the partition type is VFAT, do a regular mkfs.vfat
- if mkfs.vfat doesn't exist, use mkfs.dos
- only try to add 'LABEL=' to ext2 and ext3 partitions
- moved a bunch of scripts from Mindi's rootfs.tgz to our restore-scripts.tgz
- fixed bugs in mondo-restore.c, which would sometimes just sit there when trying to compare or restore big files that were spread across CD's
- Interactive Mode goes straight to 'mondo-restore --interactive' now, i.e.  the user doesn't have to choose Interactive once at boot and once within mondo-restore
- better post-run clean-up
- improved mondo-restore.c's error-reporting a little bit
- stablilo-me (the script) now supports Red Hat's "LABEL=" extensions to /etc/fstab, via the script, 'label-partitions-as-necessary'
- added a user-friendly mountlist editor to mondo-restore.c
- added lots of sanity-checking to mountlist editor

* Sat Aug 18 2001 Bruno Cornec <bruno@mondorescue.org> 1.12-1
- Updated to 1.12
- changed cdrecord's FIFO size to 8MB
- removed -pad and -sort from the call to mkisofs
- amended the .spec file to be saner when building RPM's
- archives are named '.afio.bz2' instead of '.tar.bz2'
- mondo-archive, mondo-tarme, mondo-restore.c and the DEPRECATED scripts have been amended accordingly
- should be able to create up to 20 CD-R's per backup set now
- moved a line within prep-me that was in the wrong place (thanks, Fran Boon!)
- runs 'df -m' and saves it to a text file 'df.txt' on the CD
- added 10-second delay before mondo-restore's Nuke Mode, to let the user abort
- really fixed the '/mnt/RESTORING/tmp' permissions bug (thanks, Ang Tan!)
- sometimes, bash gets all screwed up & won't let the user type 'continue' when Mondo asks them to; if that happens, Mondo will detect it & use a different kind of mondo-askme; the new mondo-askme will check every 10 minutes for a blank CD; if it's there, then the burn continues
- abort if isodir or scratchdir is a softlink
- replaced mondo-askme with a good shell script, to work around flaws in bash and/or kernel (don't know which)
- added a failsafe kernel to Mindi, which means you don't have to make sure your kernel is suitable for a boot disk; you can just use Mindi's instead
- make+chop filelist _after_ calling Mindi
- updated the FAQ

* Sun Aug 12 2001 Bruno Cornec <bruno@mondorescue.org> 1.10-1
- Updated to 1.10
- changed cdrecord's FIFO size back to 4MB
- added -pad -sort to the call to mkisofs
- stop saying, "N files differ so far" after comparing each tarball
- updated the FAQ, to remind users that they can boot from floppy images if their kernel does not have the right support of CD-ROM's, filesystems, etc.
- erroneous error-reporting by /mondo/biggify-me; fixed (David Granz)
- don't estimate the time remaining unless >20 sets processed already
- default set size (uncompressed) is now 8MB (was 12MB); when 8MB, seems to run more smoothly & a little quicker, too, at restore-time
- chmod 1777 /mnt/RESTORING/tmp after restoring/creating /tmp
- dropped mondo-askme.c; using regular 'read' instead
- mondo-restore.c uses newt instead of ncurses; much prettier that way
- cdrecord now uses a 16MB FIFO buffer (was 8MB)
- fixed floating point error in mondo-restore (when showing progress)
- when mondo-restore is called without params (e.g. by Interactive Mode), it lets the user choose between nuke, interactive or compare (or abort)
- updated the FAQ
- working on Cuckoo Mode...

* Thu Aug 02 2001 Bruno Cornec <bruno@mondorescue.org> 1.09-1
- Updated to 1.09
- default compression level is now 3 (was 2)
- retry/fail/abort loop bug fixed
- calls mindi with "--custom $TMP $scratchdir/images" to force mindi to use my temp dir and to put the images in my 'images' folder

* Sat Jul 28 2001 Bruno Cornec <bruno@mondorescue.org> 1.08-1
- Updated to 1.08
- offer to Retry/Fail/Abort if an error occurs when Mondo tries to burn a CD-R
- warn if kernel is 2.4.[0-5] (could have buggy loopfs code)
- tested with RAID-5 --- works fine :-)

* Sun Jul 22 2001 Bruno Cornec <bruno@mondorescue.org> 1.07-1
- Updated to 1.07
- fixed cosmetic mistake in an error msg in mondo-tarme ('continue'-related)
- hack-fstab now uses "defaults 0 0" instead of "default 1 3" when making a new entry in /etc/fstab
- /mondo/restore-me always makes /mnt/RESTORING/tmp; so does mondo-restore.c
- cosmetic changes to mondo-restore.c's screen output
- RAID-related enhancements to mondo-restore.c - RAID bkp/restore appears to be stable - it is possible to move from non-RAID to RAID by backing up, wiping, creating /etc/raidtab, modifying /tmp/mountlist.txt and then restoring - mondo-restore.c works well - the only weakness is that the kernel's messages are written to the current console, not to a separate console... HELP? :-)
- updated README (esp. FAQ) and TODO
- tested with Linux 2.4.7; works fine
- mondo-1.07.spec and install.sh compile every C program with -lncurses, just in case some programs (besides mondo-restore.c) need the NCURSES library
- mondo-restore.c is now compiled statically

* Thu Jul 19 2001 Bruno Cornec <bruno@mondorescue.org> 1.06-1
- Updated to 1.06
- now software-RAID compatible
- install.sh only compiles mondo-restore.c once now
- if scratchdir or isodir contain more than one path (each), abort
- mondo-restore.c creates dummy partitions if the user starts the official etc/fstab table at /dev/hda7 or something; so, partitioning should work, even if the mountlist has some gaps
- for each /dev/md* device in the mountlist, run raidstop before mkraid

* Mon Jul 16 2001 Bruno Cornec <bruno@mondorescue.org> 1.05-1
- Updated to 1.05
- patch from DoJ to make install.sh compile with -O2, not -O
- cosmetic changes to the biggiefile-slicing code
- fixed install.sh

* Sun Jul 15 2001 Bruno Cornec <bruno@mondorescue.org> 1.04-1
- Updated to 1.04
- make-me-bootable only "boot-makes" each partition ONCE now
- cosmetic changes to mondo-restore's logfile output
- mondo-restore.c makes /mnt/RESTORING/tmp if necessary
- should be able to cope with Red Hat's "LABEL=" messages in /etc/fstab

* Sat Jul 14 2001 Bruno Cornec <bruno@mondorescue.org> 1.03-1
- Updated to 1.03
- looks for /etc/lilo.conf; aborts if it cannot locate it
- abort if burning CD's & verify level>=2 (must be 1 or 0 if burning CD's)
- catch errors in MakeIsoFS, if any
- added 'mondo-restore.c'
	- C program, to replace the old restore scripts
	- Mindi will incorporate it in the data disks, if it can find Mondo - Mindi will also incorporate the old restore scripts (from Mondo) just in case the new C program doesn't work
	- calls the script, 'stablilo-me' to run LILO if desired
- added 'restore-scripts.tgz', which contains the /mondo scripts that used to live in Mindi; now, Mindi grabs them from here if necessary
- cleared up Mode-related scripts & the executable to replace them
- if mkisofs fails, ABORT, don't just warn
- added '--differential' option, to backup the files changed during the last N days (N specified by user)

* Sat Jul 07 2001 Bruno Cornec <bruno@mondorescue.org> 1.02-1
- Updated to 1.02
- retract the CD tray after asking user to enter 'continue' (PauseAndAskForCDR)
- uses C program instead of bash loop for PauseAndAskForCDR; some bash versions go into an infinite loop for no reason; hopefully, outsourcing to C will help
- when slicing, indicate progress ("N slices...")
- when told to '--burn-cds', Mondo pipes mkisofs's output to cdrecord, instead of saving the ISO file to disk first; this change will save time and space (not in the Star Trek sense, however *smile*)
- default set size (native) is now 12MB
- copy /usr/share/mondo to correct directory within CD
- all calls to gawk have been replaced with calls to awk
- RPM and SRPM published
- delete $TMP at end; don't just delete $TMP/*
- can accept multiple parameters in the '--bkpath' switch

* Wed Jul 04 2001 Bruno Cornec <bruno@mondorescue.org> 1.00-1
- Updated to 1.00
- thanks to recent changes to Mindi, Mondo is now compatible with the filesystem formats JFS, ext3, ReiserFS, XFS and ext2 (if your own kernel is)
- CDs [2-N] do not have boot floppy images on them; only CD#1 does (although CDs [2-N] do have the El Torito boot image, just in case...)
- modified the --burn-cds switch; now it takes 3rd param, 'cdrw' (optional) to let you wipe and rewrite CDRWs instead of wasting CDRs ;-)
- removed that PID thing; doesn't work; please don't run Mondo twice at once :)
- removed that "filenames contain '|'" error & associated problems
- got rid of 'UNSAFE' warning/shortcut
- removed --xerox-dev, --include-tarball, --skip-tildes, --ide-opt, --use-bzip2
- mondo-archive doesn't make/hack/edit mountlist anymore; that's Mindi's job
- uses Mindi Linux to make boot disks & data disks based on your distro
- boot&data stuff goes in $scratchdir/images now
- bzip2 is used by default to compress archives
- don't make MD5 checksums if verify_level==0
- when archiving, make N.tar.bz2 and cklist.txt (tarball+checksums) in parallel
- at end of mondo-archive, remove scratchdir and TMP completely IF they were created by Mondo (e.g. /home/mondo.scratch or /home/tmp.mondo.12345)
- fill CD/image up to 1MB less than its max size; was being filled up to about 8MB less than its max size, which wasted 8-10MB of storage space per disk

* Thu Mar 15 2001 Bruno Cornec <bruno@mondorescue.org> 0.99-1
- Updated to 0.99
- /proc and /tmp removed --- i.e. added to exclude list :)
- Mondo now uses 2.4-series kernel and modules (Bruno Cornec)
- minor typos fixed (Bruno Cornec)
- older, restore-related fixes merged w/Bruce's work (Maciej Kulasa)
- better RPM spec file (Bruno Cornec)
- incorporated Mondo v0.977's restore scripts' bugfixes (Maciej Kulasa)

* Tue Mar 06 2001 Bruno Cornec <bruno@mondorescue.org> 0.981-1
- Updated to 0.981
- put 'dd' in coolstuff.tgz (Art Wells)

* Wed Feb 28 2001 Bruno Cornec <bruno@mondorescue.org> 0.98-1
- Updated to 0.98
- INSTALL script renamed to install.sh
- tarball cleaned up and re-tarred (Art Wells)
- trailing CR/LF's cleaned from scripts (Art Wells)
- work is underway to make Mondo compatible with the Linux kernel's 2.4 series

* Mon Feb 26 2001 Bruno Cornec <bruno@mondorescue.org> 0.977-1
- Updated to 0.977
- based on v0.976
- missing subs and silly typos fixed in restore scripts (Maciej Kulasa)
- fstab files containing NFS mounts are handled properly (Petre Scheie)
- Mondo is being actively developed again (yippee!)

* Fri Sep 01 2000 Bruno Cornec <bruno@mondorescue.org> 0.976-1
- Updated to 0.976
- technical changes - 12MB ramdisk - repackaged: now, Mondo comes in big tarball/RPM with all overhead-files - each Mondo CD has a 15MB administrative overhead; used to be 50-60MB - definitely 386-compatible now (RH 6.2 binaries) - Linux-Mandrake 7.1 (2.2.16) kernel w/ReiserFS & Supermount - modules.conf / conf.modules support (whichever you've got) - user may include their own copies of modules, if Mondo doesn't come with the requisite modules already
- extra facilities - ReiserFS support - '--load-modules <foo> <bar> ...' will allow you to force Mondo to load key modules at boot-time, e.g. aic7xxx for SCSI-only users
- bugfixes - path-exclusion code (mondo-backup) - bogus 'flaws=1' message has been eradicated - CDRW-finding code is now much better at finding the CDRW correctly - dummy burn mode is working again - fixed security hole (thanks, Matija); now, user will be warned if Mondo is configured to execute /tmp/mondo-tarme - changed lots of 'grep " $string "' to 'grep -w "$string"' (thanks, Matija)

* Mon Jul 03 2000 Bruno Cornec <bruno@mondorescue.org> 0.975-1
- Updated to 0.975
- made mondo-tarme use 'ask-me-a-question' to pause for new, blank CD-Rs
- don't deeply search isodir for ISO files to wipe: maxdepth should be 1
- 386-compatible kernel and modules (should be, anyway...)
- applied Doug Nordwall's calc-disk-size patch to fix SCSI hdd size calc'n bug
- applied Michael Ralph Pape's SCSI (2nd floppy) patch
- removed devdump from overhead-list
- mkisofs no longer called with '-quiet' switch
- changed '--burn-cds' format: now it's --burn-cds <speed> (<device>)
- added '-L' to LILO's call, so that >8GB hard disks overcome 1024-blk limit
- mondo-compare runs check-mountlist-sanity before mounting partitions
- ramdisk is now 14MB

* Fri Jun 16 2000 Bruno Cornec <bruno@mondorescue.org> 0.972-1
- Updated to 0.972
- auto-archive, mondo-archive and mondo-tarme updated to make them more friendly towards mult-disk sets
- if multiple CDRW drives, user is asked which mondo-archive should use

* Wed Jun 14 2000 Bruno Cornec <bruno@mondorescue.org> 0.971-1
- Updated to 0.971
- auto-archive now passes CD size to mondo-archive
- mondo-tarme, in conjunction with auto-archive, now handles CDRW boot/burn sharing much better than before

* Sat Jun 10 2000 Bruno Cornec <bruno@mondorescue.org> 0.970-1
- Updated to 0.970
- kernel now creates 12MB ramdrive (was 16MB)
- lots of silly bugs & overhead problems fixed; 2nd floppy closer to working
- restore scripts all log to /var/log/mondo-restore.log
- auto-archive:- - offers Low, Medium or High compression - no longer needs a spare hard drive for scratch space; uses loopfs on existing hard drive (if possible) instead - handles weird (multi-CDROM) PCs more gracefully now - handles PCs with CDRW but without CDROM more gracefully now - deletes each ISO after burning it to a CD-R (if it _is_ burning them) - asks if PC is old & crappy; if it is, IDE optimizations are disabled at backup-time and restore-time - lets user use CDRW for booting _and_ burning, thanks to reroute-softlinks
- selective restore is finally fixed
- nicer help screens on boot floppy

* Sat Jun 03 2000 Bruno Cornec <bruno@mondorescue.org> 0.965-1
- Updated to 0.965
- 2MB of space left empty at end of every CD (e.g. 650MB is only 648MB full)
- Suzhe & Lonius's SmartBootManager (sbminst) is used instead of Win98's MBR
- Mondo may now resize Windows-only backups when restoring
- silly bugs in prep-me... fixed

* Fri Jun 02 2000 Bruno Cornec <bruno@mondorescue.org> 0.964-1
- Updated to 0.964
- VFAT partitions >8GB handled OK now
- 2nd floppy (optionally) created for SCSI users <--- not working yet
- better calc-disk-size algorithm (thanks, Doug Nordwall)
- Mondo can now backup and restore Windows-only PCs! :-)
- silly prep-me and format-and-kludge-vfat bugs fixed
- 'resize hack' retitled as 'vacuum-pack'

* Wed May 31 2000 Bruno Cornec <bruno@mondorescue.org> 0.963-1
- Updated to 0.963
- ISO images are no longer padded
- all currently-loaded modules are backed up to custom hboot.img & installed at restore-time before CD is accessed
- '--burn-cd <speed>' switch added
- '--no-opt' switch added; use it in the call to mondo-archive if you don't want IDE optimization when restoring
- lots of work done on auto-archive
- mondo-extras-1.5 created; excludes mondo-zfile but includes hlib.tar.bz2
- boot floppy image now includes kernel w/lots of SCSI stuff
- slice* deleted (WipeArchives); was 'slices*' (bug!)
- restore scripts all use 'lastbit-me' to find the 'X' part of '/dev/X' device; this will make it easier to port Mondo to kernel 2.4.x
- I cannot make SCSI-based CDROMs boot from Mondo CDs properly... but SCSI hard drives and ZIP drives should be handled ok from now on
- with a little coaxing, Mondo will backup Windows-only PCs (as well as Lin/Win and Linux-only PCs)

* Thu May 25 2000 Bruno Cornec <bruno@mondorescue.org> 0.962-1
- Updated to 0.962
- silly bug in mondo-checksum fixed
- stale tmp dirs are now definitely deleted (bug fixed)
- "Job is  percent d complete. hh:ss to go." --- much better 'progress' string
- 'buffer' is gone again :) thank goodness
- only 1st ISO is padded; the rest aren't.
- working on implementing an easy 'cdrecord' shortcut-call-thingy
- mondo-archive doesn't try to delete loopfs unless it exists
- mondo-restore's "hack-softlinks" - silly bug ($1/ missing) fixed
- boot floppy image now includes mkdir and rmdir
- user may specify temp directory using '--tempdir <path>'
- mondo-archive now includes a copy of 'buffer' for future use
- Mondo will now archive and restore Linux AND LinWin systems ok. W00H00! :-)

* Tue May 23 2000 Bruno Cornec <bruno@mondorescue.org> 0.961-1
- Updated to 0.961
- mondo-checksum ignores files <2k in length
- default compression level is 4
- default verify level is 2
- files <3k in size aren't compressed
- filelist no longer includes bashbug, dosfsck or dir
- bs-me is disabled in mondo-restore
- fixed bug in 'hack-fstab' which stopped processing fstab if blank line found

* Mon May 22 2000 Bruno Cornec <bruno@mondorescue.org> 0.960-1
- Updated to 0.960
- mondo-vfat-1.0 package released, to provide kludging for VFAT bootables
- logfile now saved at /var/log/mondo-archive.log (not `pwd`/mondo-archive.log)
- pid registered/checked _after_ command line processed... so you can do --help without being shouted at ;)
- restore-me broken into 2 scripts: untar-me and biggify-me
- restore-subroutine-me now renamed untar-subroutine-me
- bzip2 decompression should work again ;) ... a missing '-Z' was added to the afio call, and the usr/lib/libbz* libraries are now included on CD ISOs
- fixed hack-lilo to ignore blank lines
- really ugly boot kludge has been implemented, using embleer files to make newly-formatted VFAT partitions bootable


