#!/bin/sh
# live images are specified with
# root=mgalive:backingdev

[ -z "$root" ] && root=$(getarg root=)

if [ "${root%%:*}" = "mgalive" ] ; then
    liveroot=$root
fi

[ "${liveroot%%:*}" = "mgalive" ] || return

modprobe -q loop

case "$liveroot" in
    mgalive:LABEL=*|LABEL=*) \
        root="${root#mgalive:}"
        root="$(echo $root | sed 's,/,\\x2f,g')"
        root="mgalive:/dev/disk/by-label/${root#LABEL=}"
        rootok=1 ;;
esac
info "root was $liveroot, is now $root"

# make sure that init doesn't complain
[ -z "$root" ] && root="mgalive"

wait_for_dev /live/union
