#!/bin/sh

case "$root" in
  mgalive:/dev/*)
    {
        printf 'KERNEL=="%s", RUN+="/sbin/initqueue --settled --onetime --unique /sbin/mgalive-root $env{DEVNAME}"\n' \
            ${root#mgalive:/dev/}
        printf 'SYMLINK=="%s", RUN+="/sbin/initqueue --settled --onetime --unique /sbin/mgalive-root $env{DEVNAME}"\n' \
            ${root#mgalive:/dev/}
    } >> /etc/udev/rules.d/99-mgalive.rules
    wait_for_dev "${root#mgalive:}"
  ;;
  mgalive:*)
    if [ -f "${root#mgalive:}" ]; then
        /sbin/initqueue --settled --onetime --unique /sbin/mgalive-root "${root#mgalive:}"
    fi
  ;;
esac
