#!/bin/bash
# -*- mode: shell-script; indent-tabs-mode: nil; sh-basic-offset: 4; -*-
# ex: ts=8 sw=4 sts=4 et filetype=sh

check() {
    # an installer host-only image doesn't really make a lot of sense
    [[ $hostonly ]] && return 1
    return 255
}

depends() {
    return 0
}

installkernel() {
    instmods squashfs loop overlay

    # This bit is a bit hacky. We need to install kernel modules we don't actually
    # want. We will keep them until depmod is run, then rm them again.
    if [[ "$DRAKX_FAKE_MODULES" && -f "$srcmods/modules.dep" ]]; then
        fakemoddir="${initdir}/lib/modules/${kernel}/kernel/mageia-fake-modules"
        mkdir -p "${fakemoddir}"
        regexp="/("$(echo $DRAKX_FAKE_MODULES | sed 's/^[[:space:]]*\(.*[^ ]\)[[:space:]]*$/\1/' | sed 's/ /|/g')")\.ko"
        modfiles=$(cut -d':' -f1 $srcmods/modules.dep | grep -E "$regexp" | xargs)
        ( cd $srcmods/; cp -f $modfiles "${fakemoddir}/" )
    fi
    return 0
}

install() {
    local _arch _libdir
    _arch=$(uname -m)
    _libdir=lib
    if [ "x86_64" = "$_arch" ]; then
      _libdir=lib64
    fi

    inst_simple "$srcmods/modules.description" "/lib/modules/$kernel/modules.description"
    inst /usr/share/terminfo/l/linux /usr/share/terminfo/l/linux
    inst /usr/share/ldetect-lst/pcitable.gz /usr/share/ldetect-lst/pcitable.gz
    inst /usr/share/ldetect-lst/usbtable.gz /usr/share/ldetect-lst/usbtable.gz
    inst /usr/share/pci.ids /usr/share/pci.ids
    inst /usr/share/ldetect-lst/dkms-modules.alias /usr/share/ldetect-lst/dkms-modules.alias
    inst /usr/share/ldetect-lst/fallback-modules.alias /usr/share/ldetect-lst/fallback-modules.alias
    inst_libdir_file "libnss_dns.so*"
    # below has /usr added...
    inst /usr/lib/module-init-tools/ldetect-lst-modules.alias /usr/lib/module-init-tools/ldetect-lst-modules.alias

    # To allow for debug build of stage1
    if [ -n "$DRAKX_STAGE1_BINARY" -a -x "$DRAKX_STAGE1_BINARY" ]; then
      inst "$DRAKX_STAGE1_BINARY" /usr/sbin/stage1
    else
      inst /usr/${_libdir}/drakx-installer-binaries/stage1 /usr/sbin/stage1
    fi

    if [ -n "$DRAKX_INIT_BINARY" -a -x "$DRAKX_INIT_BINARY" ]; then
      inst "$DRAKX_INIT_BINARY" /usr/sbin/stage2-fake-switch_root
    else
      inst /usr/${_libdir}/drakx-installer-binaries/init /usr/sbin/stage2-fake-switch_root
    fi

    inst /usr/sbin/pppd-diet /usr/sbin/pppd
    inst /usr/sbin/pppoe-diet /usr/sbin/pppoe

    if [ "$_arch" != "ppc" -a "$_arch" != "ia64" ]; then
      inst /etc/pcmcia/config.opts /etc/pcmcia/config.opts
    fi

    inst_hook cmdline 29 "$moddir/parse-mgainstaller.sh"
    inst_hook mount 99 "$moddir/mgainstaller-mount-stage2.sh"

    inst_multiple chmod mkdir ln
}
